# WooCommerce Vulnerability Scanner (CVE-2024-45712)

A Python script designed to scan a list of WordPress sites to identify those with WooCommerce installed and check if they are vulnerable to CVE-2024-45712.

## Description:

This tool automates the process of:

1. Checking if a WordPress site has the **WooCommerce REST API enabled.**

2. Attempting to **identify** the **Woocommerce Version.** 

3. **Testing for the presence of CVE-2024-45712** an unauthenticated privilege escalation vulnerability that allows an attacker to create arbitrary orders.



**Disclaimer:** This tool is for educational and security assessment purposes only. Only test against websites you own or have explicit permission to scan.

## Features: 

- **Multi-threaded Scanning:** Process multiple targets concurrently for speed.
- **Bulk Target Processing:** Read a list of targets from a file.
- **Version Detection:** Attempts to find the WooCommerce version via readme.txt
- **Detailed Reporting:** Outputs results to both the console, and a specified file. 

## Installation & Requirements:

1. Ensure you have `Python 3.x` installed on your system.
2. Install the requireed dependency: `pip install requests`. 

## Usage:

**Basic Syntax:**  
```
python3 woocommerce_scanner.py -i input_file.txt [-o output_file] [-p ID] [-q NUM] [-t THREADS] 
```
**Arguments:**  

| Argument |  Description |  Required |
| :--- | :--- | :--- | 
|`-i`, `--input` | Path to a file containing a list of target URLs/IPs (*One per line*). |  **Yes** |
|`-o`, `--output` | File to save the scan results to. (*Default: results.txt*) | **Optional** |
|`-p`, `--product-id` | The product ID to use in the test order.(*Default: 1*) | **Optional** |
|`-q`, `--quantity` | The quantity of the product to order.(*Default: 1)* | **Optional**
|`-t`, `--threads` | Number of concurrent threads to use for scanning.(*Default: 5*) | **Optional** |





# Examples:

### 1. Basic Scan with default settings:

``` 
python3 woocommerce_scanner.py -i targets.txt
```
### 2. Scan with a custom product ID , saving to a specific file:
```
python3 woocommerce_scanner.py -i targets.txt -o results.txt -p 15
```

### 3. Scan with 10 concurrent threads:
```
python3 woocommerce_scanner.py -i targets.txt -t 10 
```
## Input File Format:

The input file should be a **plain text file** with **one target per line.** Targets can be **URLs or IP addresses.** The scheme *(http/https)* is *optional* ; **http will be used as a default.** 


 **Example of**  *input_file.txt:*

 [example.com](http://www.example.com)  

 [https://mysite.com](https://mysite.com)  

 [192.168.1.100](http://192.168.1.100)

 [http://testshop.org/wp](http://testshop.org/wp)


 ## Output: 

 
 **Console output example:**
The script provides *real-time output* to the console and writes detailed results to the *specified output file.*

[\*] Loaded 5 targets from targets.txt  
[\*] Starting scan with 5 threads...


[+] Scanning: [http://example.com](http://example.com)  
[-] [http://example.com](http://example.com) - WooCommerce 6.5.1- **VULNERABLE**  
[+] Scanning: [http://testshop.org](http://testshop.org)  
[-] http://testshop.org - **No WooCommerce detected**

**The results file** (e.g., *results.txt*) will contain a block of information for each target:

**Target:** http://example.com  
WooCommerce: **True**  
Version: **6.5.1**  
Vulnerable: **True**
Details: **Order created successfully! Order ID: 1234**

## How It Works:

1. **API Check:** The script first checks for the presence of the **WooCommerce REST API** at */wp-json/wc/v3/.*

2. **Version Detection:** If WooCommerce is found, it tries to read */wp-content/plugins/woocommerce/readme.txt* to find the version number.

3. **Vulnerability Test:** It attempts to exploit **CVE-2024-45712** by sending a **POST** request to create a new order with random customer details. A successful order creation indicates the site is **vulnerable.**


### Disclaimer & Warning:

This tool is intended for use in ethical security testing only. Unauthorized testing against websites you do not own is illegal and unethical. The user assumes all responsibility for how this tool is used. Always obtain proper permission before scanning any system.

### License:
This project is for educational purposes. Use responsibly.







