```markdown
# CVE-2024-45590 - WordPress Plugin RCE PoC

## Vulnerability Details
- **CVE:** CVE-2024-45590
- **CVSS:** 9.8 (Critical)
- **Type:** Unauthenticated RCE via Arbitrary File Upload
- **Affected:** WordPress Plugin

## Proof of Concept
Demonstrates safe RCE exploitation with two commands:
1. `id` - Command execution proof
2. `ping` - Safe network connectivity test

## Setup & Execution
```bash
# Build and start environment
docker-compose up --build -d

# Wait for initialization
sleep 30

# Run PoC
docker-compose run --rm scanner --target 192.168.1.100

# Check results
cat results/result.json
```

## Expected Result
```json
[{"ip": "192.168.1.100", "vuln": true}]
```

## Project Structure
```
CVE-2024-45590/
├── docker-compose.yml
├── Dockerfile
├── README.md
├── src/scanner.py          # Main PoC
├── vulnerable/             # Vulnerable WordPress
└── results/result.json     # Scan output
```

