# CVE-2024-45440
Drupal CVE-2024-45440
core/authorize.php in Drupal 11.x-dev allows Full Path Disclosure (even when error logging is None) if the value of hash_salt is file_get_contents of a file that does not exist.   

# 使用
```
python CVE-2024-45440.py
```
![image](https://github.com/user-attachments/assets/0d66b93e-b34b-43a9-bc80-50ec81c40233)

# 靶场部署

settings.php将通过挂载的方式替换掉容器中的settings.php

替换settings.php后无法进行安装，但直接访问`http://127.0.0.1:8080/core/authorize.php`也能暴露出配置文件的完整路径

正常安装过程如下：

先将docker-ccompose.yml第15行的`- ./settings.php:/opt/drupal/web/sites/default/settings.php`注释掉，才能正常进行安装

启动docker容器

```
docker-compose up -d
```

选择语言

![image-20241226171834277](https://github.com/user-attachments/assets/064b6b23-56f8-4283-a318-9bce48a9d86e)


选择安装方式

![image-20241226171854577](https://github.com/user-attachments/assets/1b316883-6a91-4b39-8509-6abee2943ae7)


设置数据库

![image-20241226172032897](https://github.com/user-attachments/assets/24e88882-8b2c-481a-be84-e9fa3c6a1e92)


其他选项默认

设置网站

![image-20241226172625492](https://github.com/user-attachments/assets/83bd791c-6f10-4c7b-93d8-b825720d7d5e)


其他选项默认，进行安装

接下来模拟开发人员更改/sites/default/settings.php 文件中第 268 行的 hash_salt 变量，我们关闭docker容器

```
docker-compose down
```

然后取消docker-ccompose.yml第15行的`- ./settings.php:/opt/drupal/web/sites/default/settings.php`注释，再次启动容器

```
docker-compose up -d
```

靶场设置完成

# 复现

访问`http://127.0.0.1:8080/core/authorize.php`

![image-20241226170825303](https://github.com/user-attachments/assets/3901c1fd-c0ae-482a-9b22-9824e8a8283b)

暴露出配置文件的完整路径

或者使用脚本

```
python CVE-2024-45440.py
```
![image](https://github.com/user-attachments/assets/0d66b93e-b34b-43a9-bc80-50ec81c40233)
