# PoC Conceptual CVE-2024-44258: Vulnerabilidad de Symlink en iOS

**Requisito:** Python 3.7+ • **Licencia:** MIT

> ⚠️ **Advertencia:** Este repositorio contiene una prueba de concepto (PoC) desarrollada con fines **exclusivamente** educativos y de investigación. No es un exploit completamente funcional. Su uso en dispositivos sin la debida autorización está **prohibido**.

---

## Contenido

1. [Visión General](#visión-general)
2. [Detalles de la Vulnerabilidad](#detalles-de-la-vulnerabilidad)
3. [Alcance y Limitaciones](#alcance-y-limitaciones)
4. [Características del PoC](#características-del-poc)
5. [Requisitos](#requisitos)
6. [Guía de Implementación](#guía-de-implementación)

   * [Clonación del Repositorio](#clonación-del-repositorio)
   * [Configuración Crítica](#configuración-crítica)
   * [Ejecución](#ejecución)
   * [Validación Teórica](#validación-teórica)
7. [Exploit Real: Desafíos Principales](#exploit-real-desafíos-principales)
8. [Términos de Uso y Exoneración](#términos-de-uso-y-exoneración)
9. [Licencia](#licencia)
10. [Reconocimientos](#reconocimientos)

---

## Visión General

Esta PoC ilustra de forma conceptual **CVE-2024-44258**, una vulnerabilidad de resolución de symlinks durante la restauración de backups en iOS. El objetivo es demostrar la configuración mínima necesaria para explotar la falla, sin ofrecer un exploit completo.

## Detalles de la Vulnerabilidad

* **CVE ID:** CVE-2024-44258
* **CWE:** CWE-59 (Improper Link Resolution Before File Access)
* **Componentes afectados:** ManagedConfiguration framework y demonio `profiled`.
* **Resumen:** El proceso de restauración de backups no verifica si una ruta es un symlink, lo que permite escribir archivos en ubicaciones arbitrarias.
* **Impacto:** Elevación de privilegios, modificación de archivos críticos, acceso no autorizado.
* **Estado (mayo 2025):** Corregido en iOS 17.7.1, iOS 18.1, iPadOS 17.7.1, iPadOS 18.1, visionOS 2.1, tvOS 18.1 y versiones posteriores.
* **Fecha de parche:** Octubre–Noviembre de 2024
* **Investigadores:** Hichem Maloufi, Christian Mina, Ismail Amzdak

## Alcance y Limitaciones

* **Objetivo:** Comprender la mecánica interna de la vulnerabilidad.
* **No implementa:** Modificación del archivo binario `Manifest.mbdb`, paso crítico para un exploit real.
* **Resultado:** Simulación de la estructura de backup y listado de operaciones teóricas.

## Características del PoC

1. **Verificación de dependencias:** Comprueba disponibilidad de `libimobiledevice`.
2. **Detección de dispositivo:** Espera conexión de un iPhone e identifica su UDID.
3. **Generación de backup simulado:**

   * Estructura en `CVE-2024-44258_PoC_Backup`
   * Inserta un archivo payload (`.plist`) en `HomeDomain/Library/ConfigurationProfiles/`
   * Crea directorios para `SysSharedContainerDomain-systemgroup.com.apple.configurationprofiles`
   * Marca el symlink en un archivo placeholder (`Library -> SYMLINK_TARGET_ON_DEVICE`)
   * Exporta `Manifest_OPERATIONS_SIMULATED.txt` con pasos conceptuales
4. **Attempt de restauración:** Utiliza `idevicebackup2` para aplicar el backup al dispositivo.

## Requisitos

* **Sistema anfitrión:** macOS o Linux
* **Python:** ≥ 3.7
* **Libs:** `libimobiledevice` (`idevicelist`, `idevicebackup2` disponibles en PATH)

## Guía de Implementación

### Clonación del Repositorio

```bash
git clone https://github.com/missaels235/POC-CVE-2024-44258-Py.git
cd POC-CVE-2024-44258-Py
```

### Configuración Crítica

En `poc_cve_2024_44258.py`, ajuste:

* **`SYMLINK_TARGET_ON_DEVICE`:** Ruta absoluta en iOS donde se creará el enlace y se escribirá el payload.

  * Debe ser una ruta con permisos de escritura.
  * Ejemplos seguros (sandbox):

    ```text
    /private/var/mobile/Containers/Data/Application/<APP_UUID>/tmp/ExploitDir
    /private/var/mobile/Library/Caches/ExploitCache
    ```

> ⚠️ **Precaución:** Una ruta inapropiada puede invalidar la PoC o, en un exploit real, afectar la integridad del sistema.

### Ejecución

```bash
python3 poc_cve_2024_44258.py
```

1. Comprueba dependencias.
2. Conecta el iPhone.
3. Genera el backup simulado.
4. Solicita confirmación antes de restaurar.

### Validación Teórica

Si el proceso de restauración se completa:

1. Acceso al dispositivo (jailbreak + SSH o Filza).
2. Verificar en `SYMLINK_TARGET_ON_DEVICE` el archivo `PoC_File_CVE-2024-44258.plist`.
3. Confirmar contenido del payload.

> Nota: Sin modificación de `Manifest.mbdb`, la validación es meramente teórica.

## Exploit Real: Desafíos Principales

1. **Análisis de `Manifest.mbdb`:** Formato binario propietario.
2. **Herramientas de edición:** Desarrollo en C o simil.
3. **Construcción de backup malicioso:**

   * Embed del payload `.plist`.
   * Definición de symlinks en `Manifest.mbdb`.
4. **Restauración automatizada:** El sistema crea symlinks y escribe en la ruta objetivo.

## Términos de Uso y Exoneración

* **Solo uso académico y forense.**
* **Sin garantías:** Código “tal cual”.
* **Alto riesgo:** Pérdida de datos o brick de dispositivo.
* **Cumplimiento legal:** No promover actividades ilícitas.
* **Responsabilidad total del usuario.**

## Licencia

Distribuido bajo la **MIT License**. Consulte el archivo [`LICENSE`](./LICENSE).

## Reconocimientos

* **Hichem Maloufi, Christian Mina, Ismail Amzdak** — Divulgación de la vulnerabilidad.
* **Comunidad libimobiledevice** — Herramientas esenciales.
* **Autor:** Misael S. (@missaels235)
