/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.protocol;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.OverrideMustInvoke;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.jcip.annotations.GuardedBy;
import org.jenkinsci.remoting.protocol.ProtocolLayer;
import org.jenkinsci.remoting.protocol.ProtocolStack;
import org.jenkinsci.remoting.util.ByteBufferQueue;

public abstract class FilterLayer
implements ProtocolLayer,
ProtocolLayer.Send,
ProtocolLayer.Recv {
    private static final Logger LOGGER = Logger.getLogger(FilterLayer.class.getName());
    @GuardedBy(value="this")
    @Nullable
    private ProtocolStack.Ptr ptr;
    @GuardedBy(value="this")
    private int completionState;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OverrideMustInvoke
    public final synchronized void init(@NonNull ProtocolStack.Ptr ptr) throws IOException {
        FilterLayer filterLayer = this;
        synchronized (filterLayer) {
            if (this.ptr != null && this.ptr != ptr) {
                throw new IllegalStateException("Filter has already been initialized");
            }
            this.ptr = ptr;
        }
    }

    @Override
    public void start() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void completed() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "[{0}] Completed", this.stack().name());
        }
        FilterLayer filterLayer = this;
        synchronized (filterLayer) {
            if (this.completionState == 7) {
                throw new IllegalStateException("Filter has already been completed");
            }
            this.completionState |= 1;
            this.ptr.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onSendRemoved() {
        FilterLayer filterLayer = this;
        synchronized (filterLayer) {
            this.completionState |= 2;
            if (this.completionState == 7) {
                this.ptr = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onRecvRemoved() {
        FilterLayer filterLayer = this;
        synchronized (filterLayer) {
            this.completionState |= 4;
            if (this.completionState == 7) {
                this.ptr = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void abort(@NonNull IOException cause) {
        block7: {
            ProtocolStack.Ptr ptr;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LogRecord record = new LogRecord(Level.FINEST, "[{0}] Aborted");
                record.setParameters(new Object[]{this.stack().name()});
                record.setThrown(cause);
                LOGGER.log(record);
            }
            FilterLayer filterLayer = this;
            synchronized (filterLayer) {
                ptr = this.ptr;
            }
            if (ptr == null) {
                throw new IllegalStateException();
            }
            try {
                this.onRecvClosed(cause);
            }
            catch (IOException e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block7;
                LogRecord record = new LogRecord(Level.FINE, "[{0}] Close notification only partially completed");
                record.setParameters(new Object[]{this.stack().name()});
                record.setThrown(e);
                LOGGER.log(record);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected ProtocolStack<?> stack() {
        ProtocolStack.Ptr ptr;
        FilterLayer filterLayer = this;
        synchronized (filterLayer) {
            ptr = this.ptr;
        }
        return ptr == null ? null : ptr.stack();
    }

    @Nullable
    protected synchronized ProtocolStack.Ptr next() {
        return this.ptr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void flushRecv(ByteBufferQueue queue) throws IOException {
        ProtocolStack.Ptr ptr;
        FilterLayer filterLayer = this;
        synchronized (filterLayer) {
            ptr = this.ptr;
        }
        if (ptr == null) {
            throw new IllegalStateException();
        }
        ByteBuffer tmp = queue.newByteBuffer();
        while (queue.hasRemaining()) {
            ((Buffer)tmp).clear();
            queue.get(tmp);
            ((Buffer)tmp).flip();
            try {
                ptr.onRecv(tmp);
            }
            catch (IOException e) {
                queue.unget(tmp);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void flushSend(ByteBufferQueue queue) throws IOException {
        ProtocolStack.Ptr ptr;
        FilterLayer filterLayer = this;
        synchronized (filterLayer) {
            ptr = this.ptr;
        }
        if (ptr == null) {
            throw new IllegalStateException();
        }
        ByteBuffer tmp = queue.newByteBuffer();
        while (queue.hasRemaining()) {
            ((Buffer)tmp).clear();
            queue.get(tmp);
            ((Buffer)tmp).flip();
            try {
                ptr.doSend(tmp);
            }
            catch (IOException e) {
                queue.unget(tmp);
                throw e;
            }
        }
    }

    @Override
    public abstract void onRecv(@NonNull ByteBuffer var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OverrideMustInvoke
    public void onRecvClosed(IOException cause) throws IOException {
        ProtocolStack.Ptr ptr;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "[{0}] RECV Closed", this.stack().name());
        }
        FilterLayer filterLayer = this;
        synchronized (filterLayer) {
            ptr = this.ptr;
        }
        if (ptr == null) {
            throw new IllegalStateException();
        }
        ptr.onRecvClosed(cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRecvOpen() {
        ProtocolStack.Ptr ptr;
        FilterLayer filterLayer = this;
        synchronized (filterLayer) {
            ptr = this.ptr;
        }
        return ptr != null && ptr.isRecvOpen();
    }

    @Override
    public abstract void doSend(@NonNull ByteBuffer var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OverrideMustInvoke
    public void doCloseSend() throws IOException {
        ProtocolStack.Ptr ptr;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "[{0}] Closing SEND", this.stack().name());
        }
        FilterLayer filterLayer = this;
        synchronized (filterLayer) {
            ptr = this.ptr;
        }
        if (ptr == null) {
            throw new IllegalStateException();
        }
        ptr.doCloseSend();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSendOpen() {
        ProtocolStack.Ptr ptr;
        FilterLayer filterLayer = this;
        synchronized (filterLayer) {
            ptr = this.ptr;
        }
        return ptr != null && ptr.isSendOpen();
    }
}

