/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.remoting.shaded.org.glassfish.tyrus.container.jdk.client;

import io.jenkins.remoting.shaded.org.glassfish.tyrus.client.ThreadPoolConfig;
import io.jenkins.remoting.shaded.org.glassfish.tyrus.container.jdk.client.Filter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.UnsupportedAddressTypeException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

class TransportFilter
extends Filter {
    private static final Logger LOGGER = Logger.getLogger(TransportFilter.class.getName());
    private static final int DEFAULT_CONNECTION_CLOSE_WAIT = 30;
    private static final AtomicInteger openedConnections = new AtomicInteger(0);
    private static final ScheduledExecutorService connectionCloseScheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("tyrus-jdk-container-idle-timeout");
            thread.setDaemon(true);
            return thread;
        }
    });
    private static volatile AsynchronousChannelGroup channelGroup;
    private static volatile ScheduledFuture<?> closeWaitTask;
    private static volatile ThreadPoolConfig currentThreadPoolConfig;
    private static volatile Integer currentContainerIdleTimeout;
    private final int inputBufferSize;
    private final ThreadPoolConfig threadPoolConfig;
    private final Integer containerIdleTimeout;
    private final InetAddress bindingAddress;
    private volatile AsynchronousSocketChannel socketChannel;

    TransportFilter(int inputBufferSize, ThreadPoolConfig threadPoolConfig, Integer containerIdleTimeout, InetAddress bindingAddress) {
        super(null);
        this.inputBufferSize = inputBufferSize;
        this.threadPoolConfig = threadPoolConfig;
        this.containerIdleTimeout = containerIdleTimeout;
        this.bindingAddress = bindingAddress;
    }

    @Override
    void write(ByteBuffer data, final io.jenkins.remoting.shaded.org.glassfish.tyrus.spi.CompletionHandler<ByteBuffer> completionHandler) {
        this.socketChannel.write(data, data, new CompletionHandler<Integer, ByteBuffer>(){

            @Override
            public void completed(Integer result, ByteBuffer buffer) {
                if (buffer.hasRemaining()) {
                    TransportFilter.this.write(buffer, completionHandler);
                    return;
                }
                completionHandler.completed(buffer);
            }

            @Override
            public void failed(Throwable exc, ByteBuffer buffer) {
                completionHandler.failed(exc);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void close() {
        if (!this.socketChannel.isOpen()) {
            return;
        }
        try {
            this.socketChannel.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Could not close a connection", e);
        }
        Class<TransportFilter> clazz = TransportFilter.class;
        synchronized (TransportFilter.class) {
            openedConnections.decrementAndGet();
            if (openedConnections.get() == 0 && channelGroup != null) {
                this.scheduleClose();
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            this.upstreamFilter = null;
            return;
        }
    }

    @Override
    void startSsl() {
        this.onSslHandshakeCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleConnect(SocketAddress serverAddress, Filter upstreamFilter) {
        this.upstreamFilter = upstreamFilter;
        try {
            Class<TransportFilter> clazz = TransportFilter.class;
            synchronized (TransportFilter.class) {
                this.updateThreadPoolConfig();
                this.initializeChannelGroup();
                this.socketChannel = AsynchronousSocketChannel.open(channelGroup);
                if (this.bindingAddress != null) {
                    this.socketChannel.bind(new InetSocketAddress(this.bindingAddress, 0));
                }
                openedConnections.incrementAndGet();
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        }
        catch (IOException e) {
            this.onError(e);
            return;
        }
        {
            try {
                this.socketChannel.connect(serverAddress, null, new CompletionHandler<Void, Void>(){

                    @Override
                    public void completed(Void result, Void nothing) {
                        ByteBuffer inputBuffer = ByteBuffer.allocate(TransportFilter.this.inputBufferSize);
                        TransportFilter.this.onConnect();
                        TransportFilter.this._read(inputBuffer);
                    }

                    @Override
                    public void failed(Throwable exc, Void nothing) {
                        TransportFilter.this.onError(exc);
                        try {
                            TransportFilter.this.socketChannel.close();
                        }
                        catch (IOException e) {
                            LOGGER.log(Level.FINE, "Could not close connection", exc.getMessage());
                        }
                    }
                });
            }
            catch (UnresolvedAddressException | UnsupportedAddressTypeException e) {
                this.onError(e);
            }
            return;
        }
    }

    private void updateThreadPoolConfig() {
        if (openedConnections.get() != 0) {
            return;
        }
        Integer closeWait = this.containerIdleTimeout == null ? 30 : this.containerIdleTimeout;
        if (!this.threadPoolConfig.equals(currentThreadPoolConfig) || !closeWait.equals(currentContainerIdleTimeout)) {
            currentThreadPoolConfig = this.threadPoolConfig;
            currentContainerIdleTimeout = closeWait;
            if (channelGroup == null) {
                return;
            }
            closeWaitTask.cancel(true);
            closeWaitTask = null;
            channelGroup.shutdown();
            channelGroup = null;
        }
    }

    private void initializeChannelGroup() throws IOException {
        if (closeWaitTask != null) {
            closeWaitTask.cancel(true);
            closeWaitTask = null;
        }
        if (channelGroup == null) {
            QueuingExecutor executor;
            ThreadFactory threadFactory = this.threadPoolConfig.getThreadFactory();
            if (threadFactory == null) {
                threadFactory = new TransportThreadFactory(this.threadPoolConfig);
            }
            if (this.threadPoolConfig.getQueue() != null) {
                executor = new QueuingExecutor(this.threadPoolConfig.getCorePoolSize(), this.threadPoolConfig.getMaxPoolSize(), this.threadPoolConfig.getKeepAliveTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, this.threadPoolConfig.getQueue(), false, threadFactory);
            } else {
                int taskQueueLimit = this.threadPoolConfig.getQueueLimit();
                if (taskQueueLimit == -1) {
                    taskQueueLimit = Integer.MAX_VALUE;
                }
                executor = new QueuingExecutor(this.threadPoolConfig.getCorePoolSize(), this.threadPoolConfig.getMaxPoolSize(), this.threadPoolConfig.getKeepAliveTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(taskQueueLimit), true, threadFactory);
            }
            channelGroup = AsynchronousChannelGroup.withCachedThreadPool(executor, this.threadPoolConfig.getCorePoolSize());
        }
    }

    private void _read(final ByteBuffer inputBuffer) {
        if (!this.socketChannel.isOpen()) {
            return;
        }
        this.socketChannel.read(inputBuffer, null, new CompletionHandler<Integer, Void>(){

            @Override
            public void completed(Integer bytesRead, Void result) {
                if (bytesRead == -1) {
                    Filter upstreamFilter = TransportFilter.this.upstreamFilter;
                    if (upstreamFilter != null) {
                        TransportFilter.this.close();
                        upstreamFilter.onConnectionClosed();
                    }
                    return;
                }
                ((Buffer)inputBuffer).flip();
                TransportFilter.this.onRead(inputBuffer);
                inputBuffer.compact();
                TransportFilter.this._read(inputBuffer);
            }

            @Override
            public void failed(Throwable exc, Void result) {
                if (exc instanceof AsynchronousCloseException) {
                    return;
                }
                TransportFilter.this.onError(exc);
            }
        });
    }

    private void scheduleClose() {
        closeWaitTask = connectionCloseScheduler.schedule(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<TransportFilter> clazz = TransportFilter.class;
                synchronized (TransportFilter.class) {
                    if (closeWaitTask == null) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                    channelGroup.shutdown();
                    channelGroup = null;
                    closeWaitTask = null;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        }, (long)currentContainerIdleTimeout.intValue(), TimeUnit.SECONDS);
    }

    private static class QueuingExecutor
    extends ThreadPoolExecutor {
        private final Queue<Runnable> taskQueue;
        private final boolean threadSafeQueue;

        QueuingExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, Queue<Runnable> taskQueue, boolean threadSafeQueue, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, (BlockingQueue<Runnable>)new HandOffQueue(taskQueue, threadSafeQueue), threadFactory);
            this.taskQueue = taskQueue;
            this.threadSafeQueue = threadSafeQueue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable task) {
            block15: {
                try {
                    super.execute(task);
                }
                catch (RejectedExecutionException e) {
                    Runnable dequeuedTask;
                    if (this.isShutdown()) {
                        throw new RejectedExecutionException("The thread pool executor has been shut down", e);
                    }
                    if (this.threadSafeQueue) {
                        if (!this.taskQueue.offer(task)) {
                            throw new RejectedExecutionException("A limit of Tyrus client thread pool queue has been reached.", e);
                        }
                    } else {
                        Queue<Runnable> queue = this.taskQueue;
                        synchronized (queue) {
                            if (!this.taskQueue.offer(task)) {
                                throw new RejectedExecutionException("A limit of Tyrus client thread pool queue has been reached.", e);
                            }
                        }
                    }
                    if (this.getActiveCount() >= this.getMaximumPoolSize()) break block15;
                    if (this.threadSafeQueue) {
                        dequeuedTask = this.taskQueue.poll();
                    } else {
                        Queue<Runnable> queue = this.taskQueue;
                        synchronized (queue) {
                            dequeuedTask = this.taskQueue.poll();
                        }
                    }
                    if (dequeuedTask == null) break block15;
                    this.execute(dequeuedTask);
                }
            }
        }

        private static class HandOffQueue
        extends SynchronousQueue<Runnable> {
            private static final long serialVersionUID = -1607064661828834847L;
            private final Queue<Runnable> taskQueue;
            private final boolean threadSafeQueue;

            private HandOffQueue(Queue<Runnable> taskQueue, boolean threadSafeQueue) {
                this.taskQueue = taskQueue;
                this.threadSafeQueue = threadSafeQueue;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Runnable take() throws InterruptedException {
                Runnable task;
                if (this.threadSafeQueue) {
                    task = this.taskQueue.poll();
                } else {
                    Queue<Runnable> queue = this.taskQueue;
                    synchronized (queue) {
                        task = this.taskQueue.poll();
                    }
                }
                if (task != null) {
                    return task;
                }
                return (Runnable)super.take();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Runnable poll(long timeout, TimeUnit unit) throws InterruptedException {
                Runnable task;
                if (this.threadSafeQueue) {
                    task = this.taskQueue.poll();
                } else {
                    Queue<Runnable> queue = this.taskQueue;
                    synchronized (queue) {
                        task = this.taskQueue.poll();
                    }
                }
                if (task != null) {
                    return task;
                }
                return (Runnable)super.poll(timeout, unit);
            }
        }
    }

    private static class TransportThreadFactory
    implements ThreadFactory {
        private static final String THREAD_NAME_BASE = " tyrus-jdk-client-";
        private static final AtomicInteger threadCounter = new AtomicInteger(0);
        private final ThreadPoolConfig threadPoolConfig;

        TransportThreadFactory(ThreadPoolConfig threadPoolConfig) {
            this.threadPoolConfig = threadPoolConfig;
        }

        @Override
        public Thread newThread(Runnable r) {
            final Thread thread = new Thread(r);
            thread.setName(THREAD_NAME_BASE + threadCounter.incrementAndGet());
            thread.setPriority(this.threadPoolConfig.getPriority());
            thread.setDaemon(this.threadPoolConfig.isDaemon());
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        if (threadPoolConfig.getInitialClassLoader() == null) {
                            thread.setContextClassLoader(this.getClass().getClassLoader());
                        } else {
                            thread.setContextClassLoader(threadPoolConfig.getInitialClassLoader());
                        }
                        return null;
                    }
                });
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Cannot set thread context class loader.", t);
            }
            return thread;
        }
    }
}

