/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ProxyException
extends IOException {
    public ProxyException(@NonNull Throwable cause) {
        this(cause, new HashSet<Throwable>(List.of(cause)));
    }

    private ProxyException(@NonNull Throwable cause, @NonNull Set<Throwable> visited) {
        super(cause.toString());
        this.setStackTrace(cause.getStackTrace());
        Throwable causeOfCause = cause.getCause();
        if (causeOfCause != null && visited.add(causeOfCause)) {
            this.initCause(new ProxyException(causeOfCause, visited));
        }
        for (Throwable suppressed : cause.getSuppressed()) {
            if (!visited.add(suppressed)) continue;
            this.addSuppressed(new ProxyException(suppressed, visited));
        }
    }

    @Override
    public ProxyException getCause() {
        return (ProxyException)super.getCause();
    }
}

