/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.remoting.ChunkHeader;
import java.io.IOException;
import java.io.OutputStream;

class ChunkedOutputStream
extends OutputStream {
    private final byte[] buf;
    private int size;
    private final OutputStream base;

    public ChunkedOutputStream(int frameSize, OutputStream base) {
        if (frameSize < 0 || frameSize > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Illegal frame size: " + frameSize);
        }
        this.buf = new byte[frameSize];
        this.size = 0;
        this.base = base;
    }

    private int capacity() {
        return this.buf.length - this.size;
    }

    @Override
    public void write(int b) throws IOException {
        this.buf[this.size++] = (byte)b;
        this.drain();
    }

    @Override
    public void write(@NonNull byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int s = Math.min(this.capacity(), len);
            System.arraycopy(b, off, this.buf, this.size, s);
            off += s;
            len -= s;
            this.size += s;
            this.drain();
        }
    }

    public void sendBreak() throws IOException {
        this.sendFrame(false);
        this.base.flush();
    }

    @Override
    public void flush() throws IOException {
        if (this.size > 0) {
            this.sendFrame(true);
            this.base.flush();
        }
    }

    @Override
    public void close() throws IOException {
        this.sendFrame(false);
        this.base.close();
    }

    private void drain() throws IOException {
        if (this.capacity() == 0) {
            this.sendFrame(true);
        }
    }

    private void sendFrame(boolean hasMore) throws IOException {
        this.base.write(ChunkHeader.pack(this.size, hasMore));
        this.base.write(this.buf, 0, this.size);
        this.size = 0;
    }
}

