#!/bin/bash

# Title: Unauthenticated RCE via Angular-Base64-Upload Library - Fix and Verification
# Date: 18 October 2024
# Discovered by : Ravindu Wickramasinghe | rvz (@rvizx9) 
# Exploit Author: Ravindu Wickramasinghe | rvz (@rvizx9) 
# Vendor Homepage: https://github.com/adonespitogo/angular-base64-upload
# Software Link: https://github.com/adonespitogo/angular-base64-upload
# Version: prior to v0.1.21 
# Tested on: Arch Linux
# CVE : CVE-2024-42640
# Severity: Critical - 10.0 (CVSS 4.0)
# Github Link : https://github.com/rvizx/CVE-2024-42640
# Blog Post : https://www.zyenra.com/blog/unauthenticated-rce-in-angular-base64-upload.html

# DISCLAIMER: 

# This script is provided "as is" without any warranties or guarantees.
# The author does not assume any responsibility for prior exploitations,
# vulnerabilities, or issues arising from the use of this script.
# The auto-deletion functionality is designed to remove only the vulnerable
# components that have already been identified. Any missing directories upon
# renaming won't be identified by this script; hence, 100% fix for 
# this issue, including fix for prior exploitation, is not guaranteed.
# It is the user's responsibility to ensure they fully understand the impact 
# of running this script. The author will not be held liable for any accidental
# deletion of important data or for any consequences resulting from the
# use of this script.


if [ -z "$1" ]; then
    echo "usage: ./fix <path> (ex: example: ./fix.sh /app | tee -a /tmp/verify.log)"
    exit 1
fi

found_directories=$(find "$1" -type d -path "*/angular-base64-upload/demo" 2>/dev/null)


if [ -z "$found_directories" ]; then
    echo -e "\033[92m[inf]\033[0m: $(date +"%Y-%m-%d %H:%M:%S") \033[92m[status]: secure!\033[0m [directory]: 'angular-base64-upload/demo' not found! "
else
    echo -e "\033[31m[wrn]\033[0m: $(date +"%Y-%m-%d %H:%M:%S") \033[31m[status]: vulnerable!\033[0m [directory]: directory 'angular-base64-upload/demo' found!"
fi 


for directory in $found_directories; do
    KNOWN_HASHES=(
        "a4b7c3818198cabc8e4c3e3d232309e2" # uploads/index.php
        "db8a3957a5ae2423911997c072d7480b" # server.php
    )

    encode_file_content() {
        local file="$1"
        local encoded_content=""
        if [ -f "$file" ]; then
            encoded_content=$(base64 -w 0 "$file")
        fi
        echo "$encoded_content"
    }

    php_files=$(find "$directory" -type f -name "*.php" 2>/dev/null)
    if [ -z "$php_files" ]; then
        echo -e "\033[92m[inf]\033[0m: $(date +"%Y-%m-%d %H:%M:%S") \033[32m[status]: patched, no php files were found! \033[0m [directory]: $directory"
    else
        for file in $php_files; do
            file_name=$(basename "$file")
            file_hash=$(md5sum "$file" | cut -d ' ' -f 1)
            hash_matched=false
            for known_hash in "${KNOWN_HASHES[@]}"; do
                if [ "$file_hash" = "$known_hash" ]; then
                    hash_matched=true
                    break
                fi
            done
            if $hash_matched; then
                echo -e "\033[31m[wrn]\033[0m: $(date +"%Y-%m-%d %H:%M:%S") \033[31m[status]: vulnerable!\033[0m [file]: $file"
            else
                echo -e "\033[31m[wrn]\033[0m: $(date +"%Y-%m-%d %H:%M:%S") \033[31m[status]: vulnerable! \033[0;33m[potential prior exploitation!]\033[0m [file]: $file  [content]: $(encode_file_content "$file")"
            fi
        done
    fi
    # remove the demo folder 
    echo -e "\033[92m[inf]\033[0m: $(date +"%Y-%m-%d %H:%M:%S") executing rm -rf $directory"
    rm -rf $directory
    echo -e "\033[92m[inf]\033[0m: $(date +"%Y-%m-%d %H:%M:%S") please make sure to execute this script again to verify the fixes!"
done
