# CVE-2024-42049-PoC

## CVE Details
- https://nvd.nist.gov/vuln/detail/CVE-2024-42049
- TightVNC (Server for Windows) before 2.8.84 allows attackers to connect to the control pipe via a network connection.

## PoC Details
- article: https://izvd.eu/research/exploiting-cve-2024-42049
- tested on: 2.7.10, 2.8.81; most likely works on all versions where you have 'TightVNC_Service_Control' or 'TightVNC_Application_Control_On_Session_#' pipes accessible on the network.
- commands:
  - 1 - disconnect all clients - works in both 'server' and 'service' mode
  - 2 - get client list - returns a list of IPs - useful for recon?
  - 3 - shutdown server - works in both 'server' and 'service' mode
  - 4 - get server info - returns soem info about the server, not that useful
  - 5 - get server config  - returns serialized server configuration & passwords _IF SERVER IS NOT PROTECTED WITH CONTROL PASSWORD_

- notes: 
  - note that you need to connect in some way to the machine via SMB first - `net use \\192.168.42.100\` for example, with a valid account, otherwise it will say `[error]: The user name or password is incorrect.`; I will add user & password functionality soon to do this automatically...
  - as this is a named pipe attack it requires SMB to be open so the exploit can interact with TightVNC's control pipes; it will most likely not work if you can only see port 5900 open.
  - the default 'offset' is set to 30 and it works for retrieving the passwords on 2.8.81. you can set it to 21 for 2.7.10. you'll likely need to tweak it a bit for other versions - have fun