# Warp Terminal RCE (CVE-2024-41997)

Command injection via unsanitized `warp://` URI scheme handler. Full writeup at [0day.gg](https://0day.gg/blog/warp-terminal-rce/).

## Summary

| Property | Value |
|----------|-------|
| CVE | CVE-2024-41997 |
| Vulnerability | Command Injection (CWE-77) |
| Target | Warp Terminal (macOS) |
| Affected | < v0.2024.07.16.08.02 |
| Impact | Arbitrary command execution |
| Auth Required | None (1-click) |
| Attack Vector | Malicious `warp://` URL |

## Vulnerability

Warp registers a custom `warp://` URI scheme for Docker integration. The `/docker/open_subshell` action accepts a `shell` parameter that is incorporated into a command string without sanitization:

```
warp://action/docker/open_subshell?container_id=0&shell=INJECTION
```

The `container_id` is restricted to hex characters but is not validated against running containers. The `shell` parameter accepts arbitrary input, enabling command injection via shell metacharacters.

## Usage

1. Host `pwn.html` on a web server or open locally
2. Target clicks the link while Warp is running
3. Payload executes with Docker daemon privileges

The included PoC writes `id` output to `/tmp/hax` and terminates Warp to conceal the attack.

## Files

| File | Purpose |
|------|---------|
| `pwn.html` | 1-click RCE PoC |
