# ImageMagick Arbitrary Code Execution (CVE-2024-41817)

Proof of Concept exploit for ImageMagick versions <= 7.1.1-35 allowing arbitrary code execution via malicious XML delegation.

## Description

This exploit takes advantage of a vulnerability in ImageMagick that allows arbitrary code execution through specially crafted libraries. The script can:

- Detect vulnerable ImageMagick versions
- Generate malicious payloads
- Automatically deploy and execute the exploit

## Requirements

- Python 3.11+
- GCC >= 9.4.0
- Python packages:
  - paramiko

## Installation

```bash
git clone https://github.com/Dxsk/CVE-2024-41817-poc/
cd CVE-2024-41817-poc
pip install -r requirements.txt
```

## Usage

### Auto-detect vulnerable version:
```bash
python3 exploit.py -H <target> -p <port> -u <user> -P <password> -d
```

### Build payload only:
```bash
python3 exploit.py -c "command" -B
```

### Full auto mode (detect, build and deploy):
```bash
python3 exploit.py -c "command" -H <target> -p <port> -u <user> -P <password> -A
```

### Options:
- `-c, --command`: Command to execute (default: "id")
- `-H, --host`: Target host
- `-p, --port`: SSH port (default: 22)
- `-u, --username`: SSH username
- `-P, --password`: SSH password
- `-d, --detection`: Auto-detect ImageMagick if vulnerable
- `-B, --build`: Only build the payload
- `-A, --auto`: Full auto mode
- `-v, --verbose`: Verbose output

## Tested On
- Ubuntu 22.04.5 LTS
- ImageMagick 7.1.1-35

## Author
- Daihyxsk
- Github: https://github.com/Dxsk

## References
- [ImageMagick Security Advisory](https://github.com/ImageMagick/ImageMagick/security/advisories/GHSA-8rxc-922v-phg8)
- CVE: CVE-2024-41817

## Disclaimer
This tool is for educational purposes only. Use it only against systems you have permission to test.
