import docker

# Initialize Docker client
client = docker.from_env()

# Function to check vulnerability
def is_system_vulnerable(container):
    try:
        # Inspect container details
        details = container.attrs
        uid_gid = details['Config']['User']
        print(f"Container UID:GID = {uid_gid}")  # Print the UID:GID
        if uid_gid == "0:0":  # Root UID:GID
            return True
        return False
    except Exception as e:
        print(f"Error checking container details: {e}")
        return False

# Create a container with a high UID:GID
try:
    container = client.containers.run(
        "vulnerable-image",  # Replace with your test image
        user="2147483648:2147483648",  # UID:GID exceeding 32-bit signed integer
        detach=True
    )
    print(f"Container {container.id} started.")

    # Check if the system is vulnerable
    if is_system_vulnerable(container):
        print("System is vulnerable: Container is running as root!")
    else:
        print("System is not vulnerable.")
except Exception as e:
    print(f"Error: {e}")
