# CVE-2024-4041
  Yoast SEO <= 22.5 - Reflected Cross-Site Scripting

  # Description

  The Yoast SEO plugin for WordPress is vulnerable to Reflected Cross-Site Scripting via URLs in all versions up to, and including, 22.5 due to insufficient input sanitization and output escaping. This makes it possible for unauthenticated attackers to inject
  arbitrary web scripts in pages that execute if they can successfully trick a user into performing an action such as clicking on a link.

  ## Details

  - **Type**: plugin
  - **Slug**: wordpress-seo
  - **Affected Version**: <= 22.5
  - **Patched Version**: 22.6
  - **CVSS Score**: 6.1
  - **CVSS Rating**: Medium
  - **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:L/I:L/A:N
  - **CVE**: CVE-2024-4041
  - **Status**: Active

  ## POC

  1. Log in to WordPress as an administrator.
  2. Visit a crafted URL:
     - `https://<target>/?page=%22%20onmouseover%3D%22alert(document.domain)%22%20x%3D%22`
  3. In the admin bar, open the Yoast menu and hover/click **Get Yoast SEO Premium**.
  4. JavaScript executes from the injected event handler (`onmouseover`), confirming reflected XSS.
