# CVE-2024-40094 ENF (ExecutableNormalizedFields) Denial of Service Exploit

This script exploits the `CVE-2024-40094` vulnerability in `graphql-java` by triggering an **ExecutableNormalizedFields (ENF)** based denial of service. It builds a crafted GraphQL introspection query with deep nested aliases, designed to overwhelm the vulnerable server.

## Overview

The script utilizes asynchronous requests to send a series of large introspection queries to a target GraphQL server. The queries are sent as JSON payloads and are structured to exploit a specific vulnerability in how GraphQL servers handle deeply nested introspection queries. By triggering a large number of such queries in parallel, the script aims to cause a denial of service condition in vulnerable systems.

### Key Features:
- **Asynchronous Execution**: Uses `asyncio` and `aiohttp` for efficient, non-blocking requests.
- **Parallel Requests**: Launches multiple jobs (coroutines) to simulate simultaneous requests.
- **Customizable Parameters**: Several configuration options to control the number of requests, delay, and maximum requests per job.
- **Logging**: Optionally logs request results and errors to a file for analysis.

## Vulnerable Targets

This exploit targets servers running a vulnerable version of `graphql-java`, specifically those that do not properly handle deeply nested introspection queries.

### Affected Systems:
- `graphql-java` servers (versions vulnerable to `CVE-2024-40094`)

## Installation

To run the exploit, you need Python 3.7+ with the following dependencies:

- `aiohttp` for asynchronous HTTP requests
- `urllib3` for SSL handling (disables self-signed certificate warnings)

### Installing Dependencies:
You can install the required dependencies using `pip`:

```bash
pip install aiohttp urllib3
```

## Configuration
All key parameters can be supplied at runtime via command-line options:

- **URL** (`--url`): The target GraphQL API URL.
- **HEADERS** (`--header`): Customize the Authorization token and other headers as needed. Requests send JSON bodies, so include `Content-Type: application/json`. The option may be repeated.
- **JOB_COUNT** (`--job-count`): The number of concurrent jobs (coroutines) to spawn. Default is 50.
- **CONCURRENCY_LIMIT** (`--concurrency-limit`): Maximum number of simultaneous requests across all jobs. Must be ≥ `JOB_COUNT`. Defaults to the job count; increase cautiously.
- **ALIAS_COUNT** (`--alias-count`): The number of alias blocks in the query. This controls the depth and load of the query.
- **REQUEST_DELAY** (`--delay`): The delay between requests in seconds. Set to `0` for no delay or adjust as needed to avoid overwhelming the target too quickly.
- **MAX_REQUESTS_PER_JOB** (`--max-requests`): The maximum number of requests each job will send. Use `0` for unlimited requests.
- **LOG_FILE**: Optional. Specify a file path to log request results and errors.

## Usage
Clone the repository to your local machine:

```
git clone https://github.com/kabiri-labs/CVE-2024-40094.git
cd CVE-2024-40094
```

Run the script, supplying any desired options at the command line:

```bash
python CVE-2024-40094.py \
  --url https://api.example.com/graphql \
  --header "Authorization: Bearer <token>" \
  --header "Host: api.example.com" \
  --job-count 50 \
  --alias-count 500 \
  --concurrency-limit 50
```
The script will start sending requests to the target server. You will see the status of each request printed to the console, and logs will be written to the specified log file.

Example Output:
```
[Worker-0] Status: 200, Len: 1000, Time: 0.35s, Snippet: {"data":{"__schema":{"types":[...]}...
[Worker-1] Status: 200, Len: 1050, Time: 0.37s, Snippet: {"data":{"__schema":{"types":[...]}...
```

## Warnings
**Do Not Use On Unauthorized Targets**: This script is intended for security research and testing in controlled environments. Do not use this on production servers or systems without explicit authorization.

**Denial of Service Risk**: Running this script against a vulnerable server may cause it to become unresponsive or crash. Use with caution.

## License
This script is licensed under the MIT License. See the LICENSE file for more details.
