#!/bin/bash

# ==== Variables ====
GOGS_APP_USER="git"
GOGS_VERSION="v0.13.0"
GOG_INSTALLATION_DIR="/opt/gogs"
POSTGRES_USER="postgres"
POSTGRES_PASSWORD="postgres"
DATABASE_NAME="gogs"
GOGS_SECRET_KEY="BJRHSi4nIl9KFHu"

echo "[+] Installing Go Version: 1.22.5"
wget https://go.dev/dl/go1.22.5.linux-amd64.tar.gz

# Remove any previous Go installation
rm -rf /usr/local/go && tar -C /usr/local -xzf go1.22.5.linux-amd64.tar.gz

# Add /usr/local/go/bin to the PATH environment variable
export PATH=$PATH:/usr/local/go/bin

echo "[+] Checking for a successful Go installation"
go version

echo "[+] Installing PostgreSQfL"
apt update
apt install -y postgresql postgresql-contrib

# Determine PostgreSQL version
PG_VERSION=$(psql -V | awk '{print $3}' | cut -d. -f1)
PG_HBA="/etc/postgresql/$PG_VERSION/main/pg_hba.conf"

echo "[+] Enabling and starting PostgreSQL service"
systemctl enable postgresql
systemctl start postgresql

# Set password for postgres user
sudo -u $POSTGRES_USER psql -c "ALTER USER $POSTGRES_USER WITH PASSWORD '$POSTGRES_PASSWORD';"
sudo -u $POSTGRES_USER psql -U $POSTGRES_USER -c "CREATE DATABASE $DATABASE_NAME;"
echo "[+] PostgreSQL password for user '$POSTGRES_USER' set"

sed -i 's/^\(local\s\+all\s\+postgres\s\+\)peer/\1md5/' "$PG_HBA"
echo "[+] Updated pg_hba.conf to use md5 authentication for 'postgres' user"

# Restart PostgreSQL
systemctl restart postgresql
echo "[+] PostgreSQL restarted"

# Create a new user for Gogs
echo "[+] Creating system user '$GOGS_APP_USER'"
useradd -m -s /bin/bash $GOGS_APP_USER

# Setup Gogs
echo "[+] Cloning Gogs source code"
mkdir $GOG_INSTALLATION_DIR
cd $GOG_INSTALLATION_DIR
git clone -b $GOGS_VERSION --depth 1 https://github.com/gogs/gogs.git

mkdir -p $GOG_INSTALLATION_DIR/gogs/custom/conf

cat > $GOG_INSTALLATION_DIR/gogs/custom/conf/app.ini <<EOL
BRAND_NAME = Gogs
RUN_USER   = $GOGS_APP_USER
RUN_MODE   = dev

[database]
TYPE     = postgres
HOST     = 127.0.0.1:5432
NAME     = $DATABASE_NAME
SCHEMA   = public
USER     = $POSTGRES_USER
PASSWORD = $POSTGRES_PASSWORD
SSL_MODE = disable
PATH     = $GOG_INSTALLATION_DIR/gogs/data/gogs.db

[repository]
ROOT           = $GOG_INSTALLATION_DIR/gogs-repositories
DEFAULT_BRANCH = master

[server]
DOMAIN           = localhost
HTTP_PORT        = 3000
EXTERNAL_URL     = http://localhost:3000/
DISABLE_SSH      = false
SSH_PORT         = 2222
START_SSH_SERVER = true
OFFLINE_MODE     = false

[mailer]
ENABLED = false

[auth]
REQUIRE_EMAIL_CONFIRMATION  = false
DISABLE_REGISTRATION        = false
ENABLE_REGISTRATION_CAPTCHA = true
REQUIRE_SIGNIN_VIEW         = false

[user]
ENABLE_EMAIL_NOTIFICATION = false

[picture]
DISABLE_GRAVATAR        = false
ENABLE_FEDERATED_AVATAR = false

[session]
PROVIDER = file

[log]
MODE      = file
LEVEL     = Info
ROOT_PATH = $GOG_INSTALLATION_DIR/gogs/log

[security]
INSTALL_LOCK = true
SECRET_KEY   = $GOGS_SECRET_KEY
EOL

chown -R $GOGS_APP_USER:$GOGS_APP_USER $GOG_INSTALLATION_DIR

cd $GOG_INSTALLATION_DIR/gogs
echo "[+] Building Gogs..."
go build -o $GOG_INSTALLATION_DIR/gogs/gogs -buildvcs=false .

echo "[+] Starting Gogs web server..."
sudo -u $GOGS_APP_USER $GOG_INSTALLATION_DIR/gogs/gogs web
