# Ollama CVE-2024-39722 利用工具

该工具旨在利用 CVE-2024-39722，这是 Ollama 版本 <= 0.1.45 中的一个模型存在性泄露漏洞。它允许用户检查 Ollama 服务器是否存在漏洞，并尝试发现服务器上存在的模型。此外，它还可以爬取 Ollama 官方模型库以生成用于测试的潜在模型列表。

## 漏洞详情

*   **CVE ID:** CVE-2024-39722
*   **描述:** Ollama 版本 <= 0.1.45 存在模型存在性泄露漏洞。通过向 `/api/push` 端点发送特制请求，攻击者可以确定特定模型（包括不在公共库中的自定义模型）是否存在于服务器上。
*   **受影响版本:** <= 0.1.45
*   **CVSS 评分:** 7.5 (高危)

## 功能特性

*   **爬取 Ollama 模型库:** 从 Ollama 官方库 (`https://ollama.com/library`) 获取模型列表。
*   **版本检查:** 检查目标 Ollama 服务器版本是否存在漏洞。
*   **漏洞利用:** 使用已知模型名称列表，尝试发现易受攻击的 Ollama 服务器上存在的模型。
*   **多线程利用:** 使用多个线程以加快模型发现速度。
*   **结果输出:** 将爬取到的模型和泄露的模型保存到 JSON 文件。

## 环境要求

*   Python 3.x
*   `requests`
*   `lxml`
*   `termcolor`

## 安装

1.  克隆仓库或下载脚本 `CVE_2024_39722.py`。
2.  安装所需的 Python 包：
    ```bash
    pip install requests lxml termcolor
    ```

## 使用方法

```bash
python CVE_2024_39722.py [选项]
```

### 选项

*   `-h, --help`: 显示帮助信息并退出。
*   `-u URL, --url URL`: 目标 Ollama 服务器 URL (例如: `http://localhost:11434`)。
*   `-c, --crawl`: 爬取 Ollama 模型库并将其保存到 `links.json`。
*   `-o OUTPUT, --output OUTPUT`: 结果输出文件 (默认: `results.json`)。
*   `-t THREADS, --threads THREADS`: 用于漏洞利用的线程数 (默认: 10)。
*   `-v, --version-check`: 仅根据版本检查目标 Ollama 服务器是否存在漏洞。

### 示例

1.  **显示帮助信息:**
    ```bash
    python CVE_2024_39722.py -h
    ```

2.  **爬取 Ollama 模型库:**
    这将从 `https://ollama.com/library` 获取模型名称并将其保存到 `links.json`。
    ```bash
    python CVE_2024_39722.py --crawl
    ```

3.  **检查目标服务器是否存在漏洞:**
    ```bash
    python CVE_2024_39722.py -u http://localhost:11434 --version-check
    ```

4.  **利用目标服务器:**
    这将首先检查服务器的版本。如果存在漏洞，它将使用 `links.json` (如果不存在则爬取，或使用已有的文件) 来测试模型是否存在。
    ```bash
    python CVE_2024_39722.py -u http://localhost:11434
    ```

5.  **使用特定线程数进行利用:**
    ```bash
    python CVE_2024_39722.py -u http://localhost:11434 -t 20
    ```

6.  **利用并将结果保存到自定义文件:**
    ```bash
    python CVE_2024_39722.py -u http://localhost:11434 -o discovered_models.json
    ```

## 免责声明

本工具仅用于教育和授权安全测试目的。未经系统所有者明确许可，请勿在任何系统上使用。作者对因滥用或使用此工具造成的任何损害概不负责。
