# CVE-2024-37742: Clipboard Exploit in SEB ≤ 3.5.0 (Windows)
This repository contains a proof-of-concept (PoC) for exploiting CVE-2024-37742, a vulnerability in Safe Exam Browser (SEB) ≤ 3.5.0 on Windows. The vulnerability allows an attacker to share clipboard data between the SEB kiosk mode and the underlying system, compromising exam integrity. By exploiting this flaw, an attacker can bypass exam controls and gain an unfair advantage during exams.

## Disclaimer

This repository is for educational purposes only. The information provided here is intended to help developers understand the vulnerability and protect their systems. Do not use this exploit maliciously or without permission. Use of this PoC is at your own risk. The author is not responsible for any damages or legal issues that may arise from the use of this information.

## Affected Versions

SEB ≤ 3.5.0 (Windows)

## How It Works

1. Incorrect access control allows clipboard data sharing between SEB kiosk and the underlying system.
2. The exploit utilizes the pyperclip Python module to copy answers from a JSON file in the 'Answer-Key' directory, containing questions and answers.
3. In SEB kiosk mode:\
   The user copies the question.\
   The wmi Python module monitors system charge and discharge states to signal a Python script.\
   The script accesses clipboard data, searches the JSON file for the answer, and pastes it into the clipboard.
4. Finally, the user pastes the answer from the clipboard into the answer field.

[![Watch the video](https://img.youtube.com/vi/ICJSc8FsJYk/0.jpg)](https://youtu.be/ICJSc8FsJYk)

## Impact

This vulnerability allows authorized users to compromise the integrity of exams conducted using Safe Exam Browser (SEB). By exploiting incorrect access control, users can share clipboard data between the SEB kiosk mode and the underlying system. This enables them to copy exam questions, retrieve answers from an external source, and paste them back into the exam, undermining the security and fairness of the examination process.

## Mitigation/Resolution

#### 1. Upgrade to Safe Exam Browser (SEB) ≥ 3.6.0 for Windows, in the new version SEB has implemented an isolated clipboard

![3 6 0 notes](https://github.com/Eteblue/CVE-2024-37742/assets/151763816/f233f482-6e40-4af4-977a-4e3814b50b51)
\
#### 2. Configure Browser and Exam Key to use SEB 3.6.0

![Browser Exam Key](https://github.com/Eteblue/CVE-2024-37742/assets/151763816/9dd8fb08-ced4-4f68-a661-6c3d523405f8)

## References

[https://safeexambrowser.org/windows/win_usermanual_en.html] \
[https://safeexambrowser.org/windows/win_release_notes_en.html]

## License

This code is available under the MIT License. See the [LICENSE](https://github.com/Eteblue/CVE-2024-37742/blob/main/LICENSE) file for details.




