# CVE-2024-37726 MSI Center Local Privilege Escalation - Arbitrary File Overwrite Vulnerability

# Vulnerability Summary

A local privilege escalation vulnerability on Windows OS has been identified in MSI Center versions <= 2.0.36.0, which allows a low-privileged user to arbitrarily overwrite or delete high-privileged and critical files on a system. This vulnerability is caused by the MSI Center application running with NT AUTHORITY\SYSTEM privileges and writing the file to a low privilege user controlled directory, which allows a low-privileged user to manipulate the file system with symlink and trick the application into writing or overwriting files in arbitrary locations.

# **Vulnerability Details**

The vulnerability is triggered when a low-privileged user creates a directory and sets an OpLock on a file within that directory. The user can then utilize the "Export System Info" function in MSI Center to trigger a file write operation on the OpLocked file. While the OpLock is in place, the user can move the original file and create a junction to a target file, allowing the MSI Center application to overwrite or delete the target file with SYSTEM privileges.

![Untitled](CVE-2024-37726%20MSI%20Center%20Local%20Privilege%20Escalati%200fff3750575149f29933d4a87bbd3164/Untitled.png)

![Untitled](CVE-2024-37726%20MSI%20Center%20Local%20Privilege%20Escalati%200fff3750575149f29933d4a87bbd3164/Untitled%201.png)

# **Steps to Reproduce**

1. Create a directory with a single file (e.g., C:\Users\Public\eop\12345.txt).
2. Set an OpLock on the file 12345.txt.
3. Choose the "Export System Info" function in MSI Center and select the OpLocked file to trigger a file write operation.
4. The MSI Center.exe and MSI.CentralServer.exe processes will be paused due to the OpLock.
5. Move the 12345.txt to empty the directory.
6. Create a junction from the original directory to a target location (e.g., GLOBAL\GLOBALROOT\RPC Control\12345.txt).
7. Create a symbolic link from the target location to the target file (e.g., C:\Windows\lsasetup.log).
8. Release the OpLock.
9. Delete the symbolic link.
10. The target file (e.g., C:\Windows\lsasetup.log) will be deleted and overwritten.

# Privilege Escalation

We could create and install the program without admin right, install it on anyway that low privilege user have write access. As the output contain the name of the installed program, we can abuse the program name, write the result to C:\ProgramData\Microsoft\Windows\Start Menu\Programs\Startup\backdoor.bat. Whenever an administrator login, they will execute our payload and cause privilege escalation.

Be sure to user MsiInfo.exe to remove the admin requirement of installation.

```powershell
C:\Program Files (x86)\Windows Kits\10\bin\10.0.17763.0\x86\MsiInfo.exe "D:\tools\MSI Center EOP\t& calc.exe &\Release\t& calc.exe &.msi" -w 10
```

# **Steps of Privilege Escalation**

1) With Low privilege user, create and install the program with payload as program name.

![Untitled](CVE-2024-37726%20MSI%20Center%20Local%20Privilege%20Escalati%200fff3750575149f29933d4a87bbd3164/Untitled%202.png)

2) Re-run the poc but point the link to C:\ProgramData\Microsoft\Windows\Start Menu\Programs\Startup\calc.bat

![Untitled](CVE-2024-37726%20MSI%20Center%20Local%20Privilege%20Escalati%200fff3750575149f29933d4a87bbd3164/Untitled%203.png)

3) Observed that our payload has included in the output.

![Untitled](CVE-2024-37726%20MSI%20Center%20Local%20Privilege%20Escalati%200fff3750575149f29933d4a87bbd3164/Untitled%204.png)

4) By abusing the autorun features, when an administrator login, we could trick them to run arbitrary code.

![Untitled](CVE-2024-37726%20MSI%20Center%20Local%20Privilege%20Escalati%200fff3750575149f29933d4a87bbd3164/Untitled%205.png)

# **Impact**

A successful exploitation of this vulnerability allows a low-privileged user to arbitrarily overwrite or delete critical system files, leading to a potential escalation of privileges. This could result in a complete compromise of the system.

# **Reference**

https://csr.msi.com/global/product-security-advisories

# Remark

A new version (2.0.38.0) has been released on 3/7/2024 and fixed the vulnerability.

