/*
 * Copyright 2021-2022 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.cloud.dataflow.integration.test.tags;

public abstract class TagNames {

	public static final String PROFILE_DB_SHARED = "dbtests-shared";
	public static final String PROFILE_DB_SEPARATE = "dbtests-separate";
	public static final String PROFILE_OAUTH = "oauth";

	public static final String DOCKER_COMPOSE = "docker-compose";
	public static final String SLOW = "slow";

	public static final String DATABASE = "database";
	public static final String DATABASE_SLOW = "database-slow";
	public static final String DATABASE_SHARED = "database-shared";
	public static final String DATABASE_SEPARATE = "database-separate";
	public static final String DATABASE_FAILURE = "database-failure";

	public static final String POSTGRES = "postgres";
	public static final String POSTGRES_10 = "postgres_10";
	public static final String POSTGRES_11 = "postgres_11";
	public static final String POSTGRES_12 = "postgres_12";
	public static final String POSTGRES_13 = "postgres_13";
	public static final String POSTGRES_14 = "postgres_14";


	public static final String MARIADB = "mariadb";
	public static final String MARIADB_10_2 = "mariadb_10_2";
	public static final String MARIADB_10_3 = "mariadb_10_3";
	public static final String MARIADB_10_4 = "mariadb_10_4";
	public static final String MARIADB_10_5 = "mariadb_10_5";
	public static final String MARIADB_10_6 = "mariadb_10_6";

	public static final String MSSQL = "mssql";
	public static final String MSSQL_2019_CU10_ubuntu_20_04 = "mssql_2019_CU10_ubuntu_20_04";
	public static final String MSSQL_2019_CU16_ubuntu_20_04 = "mssql_2019_CU16_ubuntu_20_04";
	public static final String MSSQL_2022_CTP2_0_ubuntu_20_04 = "mssql_2022_CTP2_0_ubuntu_20_04";


	public static final String ORACLE = "oracle";
	public static final String ORACLE_12_2_0_1_se2 = "oracle_12_2_0_1_se2";

	public static final String DB2 = "db2";
	public static final String DB2_11_5_0_0a = "db2_11_5_0_0a";
	public static final String DB2_11_5_8_0 = "db2_11_5_8_0";
	public static final String DB2_10_5_0_5_3_10_0 = "db2_10_5_0_5_3_10_0";

	public static final String OAUTH = "oauth";
	public static final String UAA = "uaa";
	public static final String UAA_4_32 = "uaa_4_32";

	public static final String SKIPPER = "skipper";

	public static final String SKIPPER_2_6 = "skipper_2_6";

	public static final String SKIPPER_2_7 = "skipper_2_7";

	public static final String SKIPPER_2_8 = "skipper_2_8";

	public static final String SKIPPER_2_9 = "skipper_2_9";

	public static final String SKIPPER_main = "skipper_main";

	public static final String DATAFLOW = "dataflow";

	public static final String DATAFLOW_2_7 = "dataflow_2_7";

	public static final String DATAFLOW_2_8 = "dataflow_2_8";

	public static final String DATAFLOW_2_9 = "dataflow_2_9";

	public static final String DATAFLOW_2_10 = "dataflow_2_10";

	public static final String DATAFLOW_main = "dataflow_main";
}
