CREATE TABLE BOOT3_TASK_EXECUTION
(
    TASK_EXECUTION_ID     NUMBER NOT NULL PRIMARY KEY,
    START_TIME            TIMESTAMP(9) DEFAULT NULL,
    END_TIME              TIMESTAMP(9) DEFAULT NULL,
    TASK_NAME             VARCHAR2(100),
    EXIT_CODE             INTEGER,
    EXIT_MESSAGE          VARCHAR2(2500),
    ERROR_MESSAGE         VARCHAR2(2500),
    LAST_UPDATED          TIMESTAMP(9),
    EXTERNAL_EXECUTION_ID VARCHAR2(255),
    PARENT_EXECUTION_ID   NUMBER
)SEGMENT CREATION IMMEDIATE;

CREATE TABLE BOOT3_TASK_EXECUTION_PARAMS
(
    TASK_EXECUTION_ID NUMBER NOT NULL,
    TASK_PARAM        VARCHAR2(2500),
    constraint BOOT3_TASK_EXEC_PARAMS_FK foreign key (TASK_EXECUTION_ID)
        references BOOT3_TASK_EXECUTION (TASK_EXECUTION_ID)
)SEGMENT CREATION IMMEDIATE;

CREATE TABLE BOOT3_TASK_TASK_BATCH
(
    TASK_EXECUTION_ID NUMBER NOT NULL,
    JOB_EXECUTION_ID  NUMBER NOT NULL,
    constraint BOOT3_TASK_EXEC_BATCH_FK foreign key (TASK_EXECUTION_ID)
        references BOOT3_TASK_EXECUTION (TASK_EXECUTION_ID)
)SEGMENT CREATION IMMEDIATE;

CREATE SEQUENCE BOOT3_TASK_SEQ START WITH 1 MINVALUE 1 MAXVALUE 9223372036854775807 ORDER NOCYCLE;

CREATE TABLE BOOT3_TASK_LOCK
(
    LOCK_KEY     VARCHAR2(36)  NOT NULL,
    REGION       VARCHAR2(100) NOT NULL,
    CLIENT_ID    VARCHAR2(36),
    CREATED_DATE TIMESTAMP(9)  NOT NULL,
    constraint BOOT3_LOCK_PK primary key (LOCK_KEY, REGION)
)SEGMENT CREATION IMMEDIATE;

CREATE TABLE BOOT3_TASK_EXECUTION_METADATA
(
    ID                      NUMBER NOT NULL,
    TASK_EXECUTION_ID       NUMBER NOT NULL,
    TASK_EXECUTION_MANIFEST CLOB,
    primary key (ID),
    CONSTRAINT BOOT3_TASK_METADATA_FK FOREIGN KEY (TASK_EXECUTION_ID) REFERENCES BOOT3_TASK_EXECUTION (TASK_EXECUTION_ID)
) SEGMENT CREATION IMMEDIATE;


CREATE TABLE BOOT3_BATCH_JOB_INSTANCE
(
    JOB_INSTANCE_ID NUMBER(19, 0)      NOT NULL PRIMARY KEY,
    VERSION         NUMBER(19, 0),
    JOB_NAME        VARCHAR2(100 char) NOT NULL,
    JOB_KEY         VARCHAR2(32 char)  NOT NULL,
    constraint BOOT3_JOB_INST_UN unique (JOB_NAME, JOB_KEY)
) SEGMENT CREATION IMMEDIATE;

CREATE TABLE BOOT3_BATCH_JOB_EXECUTION
(
    JOB_EXECUTION_ID NUMBER(19, 0) NOT NULL PRIMARY KEY,
    VERSION          NUMBER(19, 0),
    JOB_INSTANCE_ID  NUMBER(19, 0) NOT NULL,
    CREATE_TIME      TIMESTAMP(9)  NOT NULL,
    START_TIME       TIMESTAMP(9) DEFAULT NULL,
    END_TIME         TIMESTAMP(9) DEFAULT NULL,
    STATUS           VARCHAR2(10 char),
    EXIT_CODE        VARCHAR2(2500 char),
    EXIT_MESSAGE     VARCHAR2(2500 char),
    LAST_UPDATED     TIMESTAMP(9),
    constraint BOOT3_JOB_INST_EXEC_FK foreign key (JOB_INSTANCE_ID)
        references BOOT3_BATCH_JOB_INSTANCE (JOB_INSTANCE_ID)
) SEGMENT CREATION IMMEDIATE;

CREATE TABLE BOOT3_BATCH_JOB_EXECUTION_PARAMS
(
    JOB_EXECUTION_ID NUMBER(19, 0)     NOT NULL,
    PARAMETER_NAME   VARCHAR(100 char) NOT NULL,
    PARAMETER_TYPE   VARCHAR(100 char) NOT NULL,
    PARAMETER_VALUE  VARCHAR(2500 char),
    IDENTIFYING      CHAR(1)           NOT NULL,
    constraint BOOT3_JOB_EXEC_PARAMS_FK foreign key (JOB_EXECUTION_ID)
        references BOOT3_BATCH_JOB_EXECUTION (JOB_EXECUTION_ID)
) SEGMENT CREATION IMMEDIATE;

CREATE TABLE BOOT3_BATCH_STEP_EXECUTION
(
    STEP_EXECUTION_ID  NUMBER(19, 0)      NOT NULL PRIMARY KEY,
    VERSION            NUMBER(19, 0)      NOT NULL,
    STEP_NAME          VARCHAR2(100 char) NOT NULL,
    JOB_EXECUTION_ID   NUMBER(19, 0)      NOT NULL,
    CREATE_TIME        TIMESTAMP(9)       NOT NULL,
    START_TIME         TIMESTAMP(9) DEFAULT NULL,
    END_TIME           TIMESTAMP(9) DEFAULT NULL,
    STATUS             VARCHAR2(10 char),
    COMMIT_COUNT       NUMBER(19, 0),
    READ_COUNT         NUMBER(19, 0),
    FILTER_COUNT       NUMBER(19, 0),
    WRITE_COUNT        NUMBER(19, 0),
    READ_SKIP_COUNT    NUMBER(19, 0),
    WRITE_SKIP_COUNT   NUMBER(19, 0),
    PROCESS_SKIP_COUNT NUMBER(19, 0),
    ROLLBACK_COUNT     NUMBER(19, 0),
    EXIT_CODE          VARCHAR2(2500 char),
    EXIT_MESSAGE       VARCHAR2(2500 char),
    LAST_UPDATED       TIMESTAMP(9),
    constraint BOOT3_JOB_EXEC_STEP_FK foreign key (JOB_EXECUTION_ID)
        references BOOT3_BATCH_JOB_EXECUTION (JOB_EXECUTION_ID)
) SEGMENT CREATION IMMEDIATE;

CREATE TABLE BOOT3_BATCH_STEP_EXECUTION_CONTEXT
(
    STEP_EXECUTION_ID  NUMBER(19, 0)       NOT NULL PRIMARY KEY,
    SHORT_CONTEXT      VARCHAR2(2500 char) NOT NULL,
    SERIALIZED_CONTEXT CLOB,
    constraint BOOT3_STEP_EXEC_CTX_FK foreign key (STEP_EXECUTION_ID)
        references BOOT3_BATCH_STEP_EXECUTION (STEP_EXECUTION_ID)
) SEGMENT CREATION IMMEDIATE;

CREATE TABLE BOOT3_BATCH_JOB_EXECUTION_CONTEXT
(
    JOB_EXECUTION_ID   NUMBER(19, 0)       NOT NULL PRIMARY KEY,
    SHORT_CONTEXT      VARCHAR2(2500 char) NOT NULL,
    SERIALIZED_CONTEXT CLOB,
    constraint BOOT3_JOB_EXEC_CTX_FK foreign key (JOB_EXECUTION_ID)
        references BOOT3_BATCH_JOB_EXECUTION (JOB_EXECUTION_ID)
) SEGMENT CREATION IMMEDIATE;

CREATE SEQUENCE BOOT3_TASK_EXECUTION_METADATA_SEQ START WITH 1 MINVALUE 1 MAXVALUE 9223372036854775807 ORDER NOCYCLE;
CREATE SEQUENCE BOOT3_BATCH_STEP_EXECUTION_SEQ START WITH 1 MINVALUE 1 MAXVALUE 9223372036854775807 ORDER NOCYCLE;
CREATE SEQUENCE BOOT3_BATCH_JOB_EXECUTION_SEQ START WITH 1 MINVALUE 1 MAXVALUE 9223372036854775807 ORDER NOCYCLE;
CREATE SEQUENCE BOOT3_BATCH_JOB_SEQ START WITH 1 MINVALUE 1 MAXVALUE 9223372036854775807 ORDER NOCYCLE;
