/*
 * Copyright 2019 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.cloud.dataflow.core;

/**
 * Runtime Property Keys used in Spring Cloud Data Flow
 *
 * @author Christian Tzolov
 */
public class StreamRuntimePropertyKeys {

	/**
	 * Mame of the deployed application as occurring in Skipper's manifest
	 */
	public static final String ATTRIBUTE_SKIPPER_APPLICATION_NAME = "skipper.application.name";

	/**
	 * Version of the deployed stream as occurring in Skipper's manifest
	 */
	public static final String ATTRIBUTE_SKIPPER_RELEASE_VERSION = "skipper.release.version";

	/**
	 * Mame of the deployed stream as occurring in Skipper's manifest
	 */
	public static final String ATTRIBUTE_SKIPPER_RELEASE_NAME = "skipper.release.name";

	/**
	 * Application unique ID as generated by the target platform deployer
	 */
	public static final String ATTRIBUTE_GUID = "guid";

	/**
	 * Application's url as provided by the target platform deployer
	 */
	public static final String ATTRIBUTE_URL = "url";

	/**
	 * Application's port as provided by the target platform deployer
	 */
	public static final String ATTRIBUTE_PORT = "port";
}
