
# CVE-2024-37010

Exploit for the CVE-2024-37010: access other user's external storage &amp; lateral movement:

https://www.cert.ssi.gouv.fr/avis/CERTFR-2024-AVI-0753/

https://owncloud.com/security-advisories/insecure-direct-object-reference-in-external-storage

## Intro

Owncloud turns a server into a cloud for storing files, like Google Drive. This enables companies, for example, to provide a cloud for employees, without it being managed by a third party.

If administrators have configured it in this way, users can also connect external storage, such as other clouds, FTP or Google Drive, to centralize files on a single cloud and thus make life easier for users.


Once we've created our external storage, we can update this form to change, for example, the "Folder name" field. When the form is updated, a request is sent with the entire form in JSON format. In this form, the 'ID' field, being an integer, is the identifier of our external storage, generated by the server when we created the storage.


## 2. Idor Idor


Let's imagine that another user on Owncloud, for example the administrator, also has external storage, with ID “18”.

Now, let's re-run the form update request as a “normal_user” user, with no special rights, but change the ID to 18, the administrator's external storage.

![[images/req.png]](images/req.png)

1. Enter the admin storage ID
2. Set an arbitrary storage name “storage_pwned”.
3. To be sure, we also specify an arbitrary host, in this case a Burp collaborator. Important note: changing the host is not mandatory. Changing the host means you break the storage configuration and the Owncloud server will no longer be able to retrieve files from the original storage.

Once the request has been sent, the server encounters a 404 error (4) and tells us that it hasn't found any storage with the ID we specified (5).

However, when we connect to the admin account, this is what we see:

![[pwned_article.png]](images/pwned_article.png)



The administrator's storage has been updated.

1. The storage name has been changed to “storage_pwned”.
2. The host has been replaced by the collaborator's address.
3. And most importantly: the user “normal_user” has been added to the users authorized to access the storage.

If we log back in as “normal_user”, we can see that we now have access to “storage_pwned”, the administrator's storage.

![[access.png]](images/access.png)



User A has managed to update user B's storage and regain access rights to it. We remind you that user A must NOT modify the host during the update request, so as not to break user B's configuration and then be able to access the latter's files.

Here's the code used to update external storage.


![[Pasted image 20241016114714.png]](images/2.png)


First of all, we can see that there is no verification of the rights of the user who has just made the request. The code does not check that the storage belongs to the user making the request. This explains why “normal_user” was able to update the administrator's storage.

Secondly, we can see that on each update, the code adds the user who has just made the request to the users authorized to connect to the storage, thus explaining why “normal_user” was magically granted access to the administrator's storage after the update.


### To sum up

In this example, we have seen how it was possible for one user to gain full access to another user's external storage and thus gain access to their personal files. This already makes it a fairly critical vulnerability.

## 3. Even further...

At this stage, as you can see, this IDOR (Insecure Direct Object Reference) is already a major vulnerability. But let's try to continue exploiting it to increase the impact it could have.

To do this, let's understand the authentication process performed by the Owncloud server for external storage in order to retrieve files. For basic authentication systems using a simple login/password pair, the cloud server will simply

![[Pasted image 20241017162909.png]](images/20241017162909.png)
Now, let's imagine that an attacker manages to update this configuration by changing the host to an address he controls. This means that the Owncloud server will now send credentials to this new address, which is controlled by the attacker.

![[Pasted image 20241017163143.png]](images/20241017163143.png)

This is exactly what we can do thanks to our vulnerability.

When we replay the update request by specifying another user's storage ID, all we have to do is change the host by specifying, for example, our collaborator Burp.

![[Pasted image 20241017163326.png]](images/20241017163326.png)


This way, when the user reconnects, the Owncloud server attempts to authenticate itself to our collaborator by sending it the user's credentials.

![[Pasted image 20241017163644.png]](images/20241017163644.png)

Magically, the collaborator receives the authentication request from the Owncloud server with the Base64-encoded credentials.

![[Pasted image 20241017163945.png]](images/20241017163945.png)

So we've just retrieved the cleartext credentials from the administrator's external storage.



### A little extra ...

For authentication on external storage, you can use your own Owncloud credentials to log in, if you use the same password, for example. When requesting an external storage update, you can specify “password::sessioncredentials” in the “authMechanism” field.

The Owncloud server will then save our credentials in clear text the next time we connect, and transfer them to our external storage device for authentication.

So you can see it coming...

This means that an attacker can also activate this mechanism for another user's external storage and thus transfer the cleartext credentials of the victim's Owncloud session to a host he controls, as we've just done.

## 4. Risk summary

CVE-2024-37010 therefore allows an attacker with an account on an Owncloud server:

- Obtain read/write access to files in other users' external storage.
- Obtain plaintext identifiers for connected external storage devices.
    - Bounce to external storages.
- Obtain unencrypted Owncloud account credentials for users with external storage.
    - Account takeover & privesc.


## Chronology

- 03/11/2024 - Vulnerability discovered
- 12/03/2024 - Report sent to Owncloud
- 09/09/2024 - Public announcement & CVE from Owncloud
