# CVE-2024-3673
CVE-2024-3673 Exploit: Local File Inclusion in Web Directory Free WordPress Plugin ( before 1.7.3 )

# Overview

**CVE-2024-3673** describes a critical vulnerability in the Web Directory Free WordPress plugin (versions prior to 1.7.3). The plugin fails to validate a parameter before using it in an `include()` function, which leads to Local File Inclusion (LFI). This allows unauthenticated attackers to read sensitive files on the server.
## Vulnerable Plugin Versions

- Affected Versions: **<= 1.7.2**
- Fixed Version: **1.7.3**

## Exploit Description

An attacker can exploit this vulnerability by sending a crafted `POST` request to the `admin-ajax.php` endpoint, abusing the `w2dc_controller_request` action to include arbitrary files from the server.

## Exploit Script

The provided Python script automates the exploitation process, including:
1. Checking the plugin version by parsing the `readme.txt` file.
2. Verifying if the target is vulnerable.
3. Exploiting the vulnerability to read sensitive files such as `/etc/passwd`.

### Usage

#### Prerequisites
- Python 3.x
- `requests` library

#### Running the Script

```bash
python3 CVE-2024-3673.py --url <TARGET_URL> [--file <TARGET_FILE>]
```

**Example:**

```bash
python3 CVE-2024-3673.py --url http://192.168.100.74/wordpress --file ../../../../../etc/passwd
```

#### Script Options
- `--url`, `-u`: The target WordPress site URL (required).
- `--file`, `-f`: The file to be read on the target server (default: `/etc/passwd`).

### Script Output
- If the plugin version is vulnerable, the script will attempt to exploit the LFI and display the file's content.
- If the plugin version is safe, it will display a message indicating that the site is not vulnerable.

## Mitigation

- **Update Plugin**: Upgrade the Web Directory Free plugin to version **1.7.3** or higher.
- **Server Hardening**:
  - Restrict file permissions to prevent unauthorized access.
  - Use a Web Application Firewall (WAF) to block malicious requests.
- **Monitoring**: Regularly scan your WordPress installation for vulnerabilities.

## Legal Disclaimer

This script is intended for educational purposes only. Unauthorized use of this exploit on systems you do not own or have explicit permission to test is illegal.
