import os
import requests

# Configuration
kubernetes_api_url = "https://kubernetes.default.svc"  # Kubernetes API URL
token_path = "/var/run/secrets/kubernetes.io/serviceaccount/token"  # Path to the service account token
namespace_path = "/var/run/secrets/kubernetes.io/serviceaccount/namespace"  # Path to the namespace

def get_service_account_token():
    try:
        # Read the service account token
        with open(token_path, 'r') as token_file:
            token = token_file.read().strip()
        print(f"[+] Service Account Token: {token}")
        return token
    except Exception as e:
        print(f"[-] Error reading token: {e}")
        return None

def get_namespace():
    try:
        # Read the namespace
        with open(namespace_path, 'r') as namespace_file:
            namespace = namespace_file.read().strip()
        print(f"[+] Namespace: {namespace}")
        return namespace
    except Exception as e:
        print(f"[-] Error reading namespace: {e}")
        return None

def access_kubernetes_api(token, namespace):
    try:
        # Set the headers with the token
        headers = {
            "Authorization": f"Bearer {token}",
            "Content-Type": "application/json"
        }
        
        # Make a request to the Kubernetes API to get pods in the namespace
        response = requests.get(f"{kubernetes_api_url}/api/v1/namespaces/{namespace}/pods", headers=headers, verify=False)
        
        # Print the response details
        print("Status Code:", response.status_code)
        print("Response Body:", response.json())
        
        if response.status_code == 200:
            print("[+] Successfully accessed Kubernetes API.")
        else:
            print("[-] Failed to access Kubernetes API.")
    except Exception as e:
        print(f"[-] An error occurred: {e}")

if __name__ == "__main__":
    # Get the service account token and namespace
    token = get_service_account_token()
    namespace = get_namespace()
    
    if token and namespace:
        # Access the Kubernetes API using the token
        access_kubernetes_api(token, namespace)
