# Transformers 中的 pickle 反序列化漏洞利用

## 实验简介
介绍pickle 反序列化机制及其__reduce__攻击原理，复现 Hugging Face Transformers 库中的反序列化漏洞[CVE-2024-3568](https://github.com/llm-sec/transformer-hacker/tree/main/docs/CVE-2024-3568)，分析 Transformers 库中的安全隐患并提出安全加固的有效方案。**详细内容参见实验PDF文档**。

（poc作者代码详见[CVE-2024-3568](https://github.com/llm-sec/transformer-hacker)或者**author_inf**文件夹）

## 关键信息
1. **漏洞位置**
`TFAutoModel.load_repo_checkpoint()` 方法（Transformers ≤ v4.37.2）

2. **攻击原理**
恶意检查点中的 `extra_data.pickle` 文件通过 `pickle.load()` 反序列化时触发RCE

3. **影响范围**
- Transformers 库 ≤ v4.37.2
- 使用检查点恢复功能的AI应用

## 环境配置
```bash
# 详细配置说明见实验PDF
pip install transformers==4.37.2 tensorflow
git clone https://github.com/llm-sec/transformer-hacker
```

## pickle 反序列化机制

详见PDF文档。

test.py、test2.py涉及原理分析（由AI问小白辅助，感谢技术突破带来的生产力提升）。

## 漏洞复现

1. **恶意检查点生成**
（具体命令见PDF文档）

2. **漏洞触发**
（代码示例见PDF文档）

3. **攻击验证**
（验证方法见PDF文档）

## 防御方案
1. **升级Transformers至≥v4.38.0**
2. **禁用`load_repo_checkpoint()`方法**
3. **实施检查点文件校验**

> **详细技术分析**：
> 完整漏洞原理、利用过程和防御策略请参考实验PDF文档
> **POC实现**：poc作者代码详见[CVE-2024-3568](https://github.com/llm-sec/transformer-hacker)或者**author_inf**文件夹