# CVE-2024-35584
OpenSIS Authenticated SQL Injection

## Description
There exists a SQL injection vulnerability in Ajax.php, ForWindow.php, ForExport.php, Modules.php, functions/HackingLogFnc.php. This finding affects OpenSis Community Edition 9.1 to 8.0 and possibly versions below.

## Proof of Concept

In one of the example, Ajax.php, it can be seen that IPs can be logged and inserted into the database if malicious activities are encountered. One thing to note is that if the “X-Forwarded-For” header is sent, the application will take that value instead of ```$_SERVER['REMOTE_ADDR']``` value. As ```$ip``` is concatenated directly into the SQL statement without any form of sanitization, it is possible to perform SQL Injection.

![image](https://github.com/user-attachments/assets/31a052fa-e14b-4f5b-ab20-c9f3f83637bc)

In the proof of concept below, injecting the payload, ```' AND SLEEP(7) AND '1'='1```, caused the application to sleep for 7 seconds, indicating that the SQL injection was successfully.
![image](https://github.com/user-attachments/assets/cbe12211-04ce-4315-a735-653aa825e1c4)

Checking the database log further proves this vulnerability.
![image](https://github.com/user-attachments/assets/fcc0d932-ed81-4539-a11a-65cc130d75b9)

Lastly, utilising SQLMap, an automated SQL Injection tool, confirmed the vulnerability.
![image](https://github.com/user-attachments/assets/36496339-22d7-4a7b-a5da-744ebcd9be8c)

## Affected files
The affected line of codes were found to directly append the value from ```$_SERVER['HTTP_X_FORWARDED_FOR']``` into a SQL statement.  

•	Ajax.php (Line 260 to 275)  
•	Modules.php (Line 1005 to 1023)  
•	ForExport.php (Line 135 to 147)  
•	ForWindow.php (Line 124 to 136)  
•	functions/HackingLogFnc.php (Line 47 to 68)  

## Recommendation

•	Instead of dynamically constructing SQL queries by concatenating user input directly into the SQL statement, utilise parameterised queries (also known as prepared statements) instead. Parameterised queries separate SQL code from user input, significantly reducing the risk of SQL injection attacks.  
•	Implement robust input validation and sanitization techniques to ensure that user-supplied data conforms to expected formats and does not contain malicious SQL code. Validate input data types, length, and format, and sanitize inputs by escaping special characters or using whitelists to allow only specific characters or patterns.  
•	Do not use ```$_SERVER[‘HTTP_X_FORWARDED_FOR’]``` to log IPs.

