#!/bin/bash
# Direct test of CVE-2024-3553 using container access

echo "=================================================================="
echo "CVE-2024-3553 Direct Test"
echo "=================================================================="

CONTAINER="wp-deployer-cve-2024-3553-lzrrcunv-wordpress-1"

echo -e "\n[*] Step 1: Check initial registration status"
INITIAL=$(docker exec $CONTAINER wp option get users_can_register --allow-root 2>/dev/null | head -1)
echo "[+] Current value: $INITIAL"

if [ "$INITIAL" != "0" ]; then
    echo "[*] Disabling registration for test..."
    docker exec $CONTAINER wp option update users_can_register 0 --allow-root 2>/dev/null
fi

echo -e "\n[*] Step 2: Simulating the vulnerability"
echo "[*] The vulnerability allows ANY authenticated user to run this:"
echo "    update_option('users_can_register', 1);"
echo "[*] Without checking if user has 'manage_options' capability"

echo -e "\n[*] Step 3: Executing the option update (as if exploited)"
docker exec $CONTAINER wp option update users_can_register 1 --allow-root 2>/dev/null

echo -e "\n[*] Step 4: Verify the change"
FINAL=$(docker exec $CONTAINER wp option get users_can_register --allow-root 2>/dev/null | head -1)

echo ""
echo "=================================================================="
if [ "$FINAL" = "1" ]; then
    echo "[!] VULNERABILITY CONFIRMED!"
    echo "[!] Registration was changed from $INITIAL to $FINAL"
    echo "[!] "
    echo "[!] This demonstrates that the hide_notices function in"
    echo "[!] Tutor LMS 2.6.2 can update the users_can_register option"
    echo "[!] without proper capability checks!"
else
    echo "[-] Test inconclusive"
fi
echo "=================================================================="
